function [xe,xo] =slfilt4_upN(y0 ,y1,IND , exten)
%low-pass filtering of  row signals or  arrays  of row signals "y0" and
%"y1" in 4-channel filter banks using spline based prediction  filters
% IND-- index of frame 
%IND(1)=4 number of channels in filter bank (3 or 4) 
%IND(2)-- pol_dis_qint
% pol_dis_qint==1--polynom. interp. spline; ==2--discr. interp. spline; 
% pol_dis_qint==3-- quasiinterp. spline; ==4 --pseudospline
%exten -- extension for recursive filtering
%IND(3)-- spline order; 
%IND(4)=0--tight frame, otherwise (IND(4)=1 or IND(4)=2)-- semi-tight frame
sq=sqrt(2);
[u1,u2,A,v1,v2] =slfilt_param4N(IND);
la=length(A);
lu=length(u1);
lv=length(v1);

xO=y1+hshif(y1,1);
xE=y0+hshif(y0,-1);
 
 ye=filX(xE,A,exten,u1,u2);
yo=filX(xO,A,exten,u1,u2);
if lv==1
Xe=y0;
Xo=y1;
else
Z=[y0;y1]; 
zn=v1(1)*Z;
ff=0;
for kk=1:(lv-1)
    ff=ff+v1(kk+1)*(hshif(Z,kk)+hshif(Z,-kk));
end
Z=(zn+ff)/v2; 
[ze,zo]=havsvB(Z); 
 Xe=ze;
Xo=zo;
end
xe=(Xe-yo)/sq;
xo=(Xo+ye)/sq;
end

% Copyright (c) 2015. Valery A. Zheludev
