function [ s0 ] = lsp0_nu(t,f, g )


%value "s0" at the point "t" of the  simplest cubic spline  designed on the grid
%"g=(g(1),...,g(N))", which approximates the data "f=(f(1),...,f(N))"
%   the point "t" should be located inside the interval [t(3),t(N-3)]

[tk,k]=max(g(g<=t));

s0=0;
for vv=-3:1
G=g(k+vv:(k+vv+4)); 
bk= bsp_nu(t,G,4 );
s0=s0+bk*f(k+vv+2);
end

% Copyright (c) 2015. Valery A. Zheludev
