function [ s0,k,TDD,h  ] = lsp0_nu1(t,f, g,k0,TDD0,h0  )

%value "s0" at the point "t" of the  simplest cubic spline  designed on the grid
%"g=(g(1),...,g(N))", which approximates the data "f=(f(1),...,f(N))"
%   the point "t" should be located inside the interval [t(3),t(N-3)]
%"k" is the index of the grid point such that t[k]<=t<=t[k+1]
%"TDD"-- set of divided differences related to  point "t" 
%"h"-- set of steps of grid points  related to  point "t" 
%"k" "TDD" and "h" are used as the input parameters "k0" "TDD0" and "h0"
%for computation of the next value "s1" at the point "t1", provided t1
%belongs to the same interval [t[k],t[k+1]] as "t" 
if nargin<4
    k0=0;
    TDD0=1;
end
[tk,k]=max(g(g<=t));
if k==k0
 TDD=TDD0;
 h=h0;
else
    K=(k-2):(k+3);
    X=g(K);
    Y=f(K);
TDD = divdiff(X, Y);
h=zeros(3,6);
for kk=1:3
h(kk,:)=circ_h(X,-kk)-X;
end
end
hk_1=g(k)-g(k-1);
hk=g(k+1)-g(k);

hk1=g(k+2)-g(k+1);
tk2=g(k+2)-g(k);
tk3=g(k+3)-g(k);
tk1_1=g(k+1)-g(k-1);
tk1_2=g(k+1)-g(k-2);
tk2_1=g(k+2)-g(k-1);
x=(t-tk)/hk;


dfk=TDD(3,3);


dgk=TDD(2,3);
rk_1=hk_1*tk1_1*dgk;
rk2=hk1*tk2*dfk;
bk=hk^2/tk2/tk3*x^3;
%bk3=hk^2/tk1_1/tk2_1*(1-x)^3;
bk3=hk^2/tk1_1/tk1_2*(1-x)^3;

s0=f(k)+TDD(3,2)*(t-tk)+bk*rk2+bk3*rk_1;
end