function [ s1,k,TDD,h  ] = lsp0_nu30(t,f, g,k0,TDD0,h0  )

%value "s1" at the point "t" of the  quasi-interpolating cubic spline  designed on the grid
%"g=(g(1),...,g(N))", which approximates the data "f=(f(1),...,f(N))"
%   the point "t" should be located inside the interval [t(3),t(N-3)]
if nargin<4
    k0=0;
    TDD0=1;
end
[tk,k]=max(g(g<=t));
 K=(k-2):(k+3);
    X=g(K);
    Y=f(K);
if k==k0
 TDD=TDD0;
 h=h0;
else
   
TDD = divdiff(X, Y);

h=zeros(4,6);
for kk=1:4
h(kk,:)=circ_h(X,-kk)-X;
end
end
d1_1=TDD(2,2);
d2_1=TDD(2,3);
d3_1=TDD(2,4);
d4_1=TDD(2,5);
d4_2=TDD(1,5);
hk_1=h(1,2);
hk=h(1,3);
hk1=h(1,4);
tk2=h(2,3);
tk3=h(3,3);
tk1_1=h(2,2);
tk1_2=h(3,1);
tk3_1=h(4,2);
tk2_2=h(4,1);
x=(t-tk)/hk;
F1=-d4_1*hk^2*hk1^2*tk3_1/3/tk2;
G1=-d4_2*hk^2*hk_1^2*tk2_2/3/tk1_1;
P3=Y(2)+d1_1*(t-X(2));%+d2_1*(t-X(2))*(t-X(3))+d3_1*(t-X(2))*(t-X(3))*(t-X(4));
s1=P3+G1*(1-x)^3+F1*x^3;