function [ s0 ] = lsp0_nu5(t,f, g )
%function [ s0,k,TDD,h  ] = lsp0_nu3(t,f, g,k0,TDD0,h0  )

%value "s0" at the point "t" of the  simplest cubic spline  designed on the grid
%"g=(g(1),...,g(N))", which approximates the data "f=(f(1),...,f(N))"
%   the point "t" should be located inside the interval [t(3),t(N-3)]
if nargin<4
    k0=0;
    TDD0=1;
end
[tk,k]=max(g(g<=t));

s0=0;
for vv=-3:1
G=g(k+vv:(k+vv+4)); 
bk= bsp_nu(t,G,4 );
s0=s0+bk*f(k+vv+2);
end

%s0=f(k)*(1-x)+f(k+1)*x+bk*rk2+bk3*rk_1;
%s0=f(k)+d1*(t-g(k))+bk*rk2+bk3*rk_1;
