function [ spec ] = gen_specN( type_gen,Par, omega ,rho)
if nargin<4
    rho=0;
end
%Fourier spectrum of the spline space generator 'type_gen' of order 'Par'
%at the point 'omega'
%   Detailed explanation goes here
u=char_fun(Par,omega);
u2=char_fun(2*Par,omega);
si=(sinc(omega/2/pi))^Par;
if  type_gen==1%interpolating

  spec=si/u;
  elseif type_gen==2%dual to B-spline 
    
    spec=si/(u2+eps); 

elseif type_gen==5%B-spline 
 spec=si;
elseif type_gen==3%dual to interpolating
   spec=si*u/u2;
elseif type_gen==4%Battle-Lemarie
spec=si/sqrt(u2);
elseif type_gen==6%smoothing 
     
   rsi=sin(omega/2);
   W=(2*rsi)^Par;
    spec=si/(rho*W+u); 

end
end

