function [spli,grid,curv]=locspla_dif_curvN(x,grid0,IND,SdSt,D,cur,inser) 
%x --samples of the input signal at grid0 points 
%IND=[Par,Q] index of spline, 'Par' -- spline order, Q--depth of quasiinterpolation 
%for smoothing Q=0
%inser==2--binary subdivision;inser==3--ternary subdivision;
%grid0 - initial sampling grid 
%D -- order of derivative 
%computation of values of a local  spline approximating the signal 'x' and  derivatives of the spline up  to order D 
%at the  refined grid= grid0/inser^SdSt
%spli--output  array with D+1 rows: first row--the spline
%k+1-th row--k-th derivative of the spline
%if cur>0 calculates  curv-- curvature of the 'spli' plot
if nargin==6
    inser=3;
end

    
lz=length(x);
step0=grid0(2)-grid0(1);
step=step0/inser^SdSt;
nn=lz*inser^SdSt;
grid=linspace(grid0(1),grid0(end),nn);
Par=IND(1); 
[y]=grid_ls_TDN(x,IND);

if inser==3
SP= tersub(y,[1,Par],SdSt,3);
elseif inser==2
 SP= binsub(y,[1,Par],SdSt,3);   
end
spli(1,:) =SP;
for dd=1:D
spli(dd+1,:) = dersp(SP,dd,step);
end
if cur==0
    curv=0;
else
curv=spli(3,:)./(1+(spli(2,:)).^2).^(3/2);
end
end

%%%%%%%%%%%%%%%%%%%%%%%%%
function di2=cent_diff2(x)%central difference of second order
di2=rshuk(1,x,3)-2*x+rshuk(-1,x,3);
end
%%%%%%%%%%%%%%%%%%%%%%%%%
function di4=cent_diff4(x)%central difference of fourth order
di4=cent_diff2(cent_diff2(x));
end

%%%%%%%%%%%%%%%%%%%%%%%%%
function di6=cent_diff6(x)%central difference of sixth order
di6=cent_diff2(cent_diff4(x));
end

%%%%%%%%%%%%%%%%%%%%%%%
function dr=  dersp(xx,dd,step)
if dd==1
    dr=(rshuk(-1,xx,3)-xx)/step;
elseif dd==2
    dr=cent_diff2(xx)/step^2;
 elseif dd==3
    dr=cent_diff2(xx)/step^2;
    dr=(rshuk(-1,dr,3)-dr)/step;
    elseif dd==4
    dr=cent_diff4(xx)/step^4;
end
end
% % % Copyright (c) 2014. Valery A. Zheludev
% 



