%
function [spli, fspli]=smoothsplaNt(x,Par,SdSt,rho,Type) 
%binary/ternary   smoothing spline subdivision
%x --samples of a signal 'x' at integer points {n=0:N-1}, N=2^j
%Par order of spline should be even number
%SdSt -- number of subdivision steps
%if  Type=2:calculation of the spline values 'spli'at dyadic rational points {n/2^SdSt}
%if  Type=3:calculation of the spline values 'spli'at triadic rational points {n/3^SdSt}

%rho -regularization parameter

lx=length(x);
fx=fft(x);
 [u1,~]=juviP(Par,lx);
n=0:lx-1;
   si=sin(pi*n/lx);
   W=(2*si).^Par;
    x=real(ifft(u1./(rho*W+u1).*fx));
    
[spli]=intersplliNt(x,Par,SdSt,Type);   


fspli=abs(fft(spli));
 %
 % Copyright (c) 2011. Valery A. Zheludev




