function [spli ]=spligenN3(type_gen,Par,N,Ll,rho)
if nargin<5
    rho=0;
end
%design of a single generator of an odd-order spline space
% type_gen type of generator
%Par -- spline order 
%N--length of interval
%Ll--number of ternary subdivision steps

 
if  type_gen==1%interpolating

  x=zeros(1,N);  
   x(1) =1;  
  elseif type_gen==2%dual to B-spline 
     [u1,~]=juviP(Par,N);
   [u2,~]=juviP(2*Par,N);
    x=real(ifft(u1./u2)); 

elseif type_gen==5%B-spline 
 [u1,~]=juviP(Par,N);
    x=real(ifft(u1));
elseif type_gen==3%dual to interpolating
     [u1,~]=juviP(Par,N);
   [u2,~]=juviP(2*Par,N);
    x=real(ifft(u1.^2./u2));
elseif type_gen==4%Battle-Lemarie

 [u1,~]=juviP(Par,N);
   [u2,~]=juviP(2*Par,N);
    x=real(ifft(u1./sqrt(u2)));

  
 elseif type_gen==6%smoothing 
     [u1,~]=juviP(Par,N);
  
   n=0:N-1;
   si=sin(pi*n/N);
   W=(2*si).^Par;
    x=real(ifft(u1./(rho*W+u1))); 

end
[spli]=intersplliNt(x,Par,Ll,3);
[v,M]=size(spli);
[e r]=max(abs(spli));
spli=circshift(spli',M/2-r)';

% Copyright (c) 2015. Valery A. Zheludev
