function [y ] = up_sq_z(x,r)
%polyphase filtering of an upsampled  signal (or rows of 2D array) by
%the FIR filter whose transfer function is (z+2+1/z)^r 
B=ones(1,r+1);
for kk=1:r
    
    B(kk)=nchoosek(2*r,kk+r-1);
end
B0=B(1:2:end);lb0=length(B0);
B1=B(2:2:end);lb1=length(B1);
y0=B0(1)*x;y1=0;
for kk=2:lb0
    y0=y0+B0(kk)*(rshuk(kk-1,x,3)+lshuk(kk-1,x,3));
%y0=y0+B0(kk)*(lshuk(kk-1,x,3)+rshuk(kk-1,x,3));
end
for kk=1:lb1
    y1=y1+B1(kk)*(lshuk(kk,x,3)+rshuk(kk-1,x,3));
%y1=y1+B1(kk)*(rshuk(kk,x,3)+lshuk(kk-1,x,3));
end

%y=[y1;y0];
y=[y0;y1];
[vy,hy]=size(y0);
y=reshape(y,vy,2*hy);
end
% Copyright (c) 2015. Valery A. Zheludev