function [K1,M2] = elemstiff(coor2)
% function [K1,M2] = elemstiff(coor2)
% For space compute stifness matrix, for load parameter compute mass matrix 
% Universidad de Zaragoza - 2015

%
% SPACE MATRICES
%
[K1] = fem2D; % Standard 2D FEM code for Triangular Elements, computing
%
% LOAD MATRICES: 1D PARAMETRIC PROBLEM
%
sg = [-1.0/sqrt(3.0) 1.0/sqrt(3.0)]; wg = ones(2,1); % Gauss points
npg = numel(sg); nen2 = numel(coor2); M2 = zeros(nen2);
X2 = coor2(1:nen2-1)'; Y2 = coor2(2:nen2)'; % Coordinates of elements
L2 = Y2 - X2; % Longitude of each  element for parametriced variable
for i1=1:nen2-1
    c2 = zeros(1,npg); N2 = zeros(nen2,npg);
    c2(1,:) = 0.5.*(1.0-sg).*X2(i1) + 0.5.*(1.0+sg).*Y2(i1);
    N2(i1+1,:) = (c2(1,:)-X2(i1))./L2(i1); 
    N2(i1,:) = (Y2(i1)-c2(1,:))./L2(i1);
    for j1=1:npg
        M2 = M2 + N2(:,j1)*N2(:,j1)'*0.5.*wg(j1).*L2(i1); % NN
    end
end
return