function  [R,S,iter] = enrichment(K1,M2,V1,V2,S0,F,G,num_iter,TOL,CC)
% function  [R,S,iter] = enrichment(K1,M2,V1,V2,S0,F,G,num_iter,TOL,CC)
% Computes a new sumand by fixed-point algorithm using PGD
% Universidad de Zaragoza - 2015
R = zeros(size(F,1),1); R0 = R; % Initial value R to compare in first loop.
h = size(V2,2); % Number functions of the source
ExitFlag = 1;
iter = 0;
mxit = 25; % #of possible iterations for the fixde point algorithm.
Free = setdiff(1:numel(F(:,1)),CC);
%
% FIXED POINT ALGORITHM
%
while ExitFlag>TOL
    %
    % LOOKING FOR R, KNOWNING S
    %
    matrixR = K1*(S0'*M2*S0);
    sourceR = zeros(size(F,1),1);
    for k1=1:h
        sourceR = sourceR + V1(:,k1)*(S0'*V2(:,k1));
    end    
    for i1=1:num_iter-1
        sourceR = sourceR - K1*F(:,i1)*(S0'*M2*G(:,i1));
    end
    %
    % SOLVE R
    %
    R(Free) = matrixR(Free,Free)\sourceR(Free);    
    %
    % LOOKING FOR S, KNOWNING R
    %
    matrixS = (R'*K1*R)*M2;
    sourceS = zeros(size(G,1),1);
    for k1=1:h
        sourceS = sourceS + V2(:,k1)*(R'*V1(:,k1)); 
    end    
    for i1=1:num_iter-1
        sourceS = sourceS - R'*K1*F(:,i1)*(M2*G(:,i1));
    end
    %
    % SOLVE S
    %
    S = matrixS\sourceS;
    S = S./norm(S); % We normalize S. R takes care of alpha constant.
    %
    % COMPUTING STOP CRITERIA
    %
    error = max(abs(sum(R0-R)),abs(sum(S0-S))); R0 = R; S0 = S;
    iter = iter + 1;
    if iter>mxit || abs(error)<TOL, 
        return
    end
end
return