function [p1,p2] = elemstiff(coor)
% function [p1,p2] = elemstiff(coor)
% For variable X compute p1=\int N N, p2=\int N
% Universidad de Zaragoza - 2015
nen = numel(coor);
%
% ALLOCATE MEMORY
%
p1 = zeros(nen); p2 = zeros(nen,1); 
X = coor(1:nen-1)'; Y = coor(2:nen)'; % Coordinates of elements.
L = Y - X; % Longitude of each  element for parametriced variable.
sg = [-1.0/sqrt(3.0) 1.0/sqrt(3.0)]; wg = ones(2,1); % Gauss points.
npg = numel(sg);
for i1=1:nen-1
    c = zeros(1,npg); c(1,:) = 0.5.*(1.0-sg).*X(i1) + 0.5.*(1.0+sg).*Y(i1);
    N = zeros(nen,npg);
    N(i1+1,:) = (c(1,:)-X(i1))./L(i1); N(i1,:) = (Y(i1)-c(1,:))./L(i1);
    for j1=1:npg
        p1 = p1 + N(:,j1)*N(:,j1)'*0.5.*wg(j1).*L(i1); % \int N N.
        p2 = p2 + N(:,j1).*0.5.*wg(j1).*L(i1); % \int N.
    end
end
return