function [R,iter] = enrichment_substep2(K,M,V,num_iter,FV,R,FR,CC,deltat)
% [R,iter] = enrichment_substep2(K,M,V,num_iter,FV,R,FR,CC,deltat)
% Compute the new R, S, functions to enrich the PGD solution for SubStep 2
% in Dynamic problems.
% Universidad de Zaragoza - 2015
iter = 1; TOL = 1.0E-4; error = 1.0; % Inicializating values.
nv = size(FV,1); % # Number of variables for the PGD.
mxit = 11; % # of possible iterations for the fixed point algorithm.
%
% FIXED POINT ALGORITHM
%
while abs(error)>TOL
    Raux = R; % Updating R(S) last values.
    for i1=1:nv
        %
        % MATRIX COMPUTATION
        %
        matrix1 = 9.0/deltat/deltat; % Constant of mass contribution.
        matrix2 = 1.0; % Constant of stiffness contribution.
        for j1=1:nv
            if j1~=i1
                matrix1 = matrix1.*(R{j1}'*M{j1}*R{j1}); 
                matrix2 = matrix2.*(R{j1}'*K{j1}*R{j1}); 
            end
        end
        matrix = M{i1}.*matrix1 + K{i1}.*matrix2;
        %
        % SOURCE COMPUTATION
        %
        source = 0.0;
        for k1=1:size(V{1},2) % Loop over number of functions of the source
            sourceval = 1.0;
            for j1=1:nv
                if j1~=i1
                    sourceval = sourceval.*(R{j1}'*V{j1}(:,k1));
                end
            end
            source = source + sourceval.*V{i1}(:,k1);
        end
        for k1=1:3:(nv-3)
            value1 = 19/deltat/deltat;% Constant value for U_n contribution
            value2 = 5/deltat; % Constant value for V_n contribution.
            value3 = 28/deltat/deltat; % Constant value for U_{n+1/2}.
            for j1=1:nv
                if j1~=i1
                    value1 = value1.*(R{j1}'*M{j1}*FR{j1}(:,k1));
                    value2 = value2.*(R{j1}'*M{j1}*FR{j1}(:,k1+1));
                    value3 = value3.*(R{j1}'*M{j1}*FR{j1}(:,k1+2));
                end
            end
            source = source - value1.*(M{i1}*FR{i1}(:,k1)) - ...
                value2.*(M{i1}*FR{i1}(:,k1+1)) +...
                value3.*(M{i1}*FR{i1}(:,k1+2));
        end
        %
        % CONTRIBUTION TO SOURCE OF KNOWNING SOLUTION
        %
        for i2=1:num_iter-1
            value1 = 9/deltat/deltat; % Constant of mass contribution.
            value2 = 1.0; % Constant of stiffness contribution.
            for j1=1:nv
                if j1~=i1
                    value1 = value1.*(R{j1}'*M{j1}*FV{j1}(:,i2)); 
                    value2 = value2.*(R{j1}'*K{j1}*FV{j1}(:,i2)); 
                end
            end
            source = source - (M{i1}*FV{i1}(:,i2)).*value1 - ...
                (K{i1}*FV{i1}(:,i2)).*value2;
        end
        %
        % SOLVE THE R{i1} VARIABLE
        %
        R{i1}(CC{i1}) = matrix(CC{i1},CC{i1})\source(CC{i1});
    end
    % 
    % COMPUTING STOP CRITERIA
    %
    error = 0; 
    for j1=1:nv
        error = error + norm(Raux{j1}-R{j1}); 
    end
    error = sqrt(error);
    iter = iter + 1;
    if iter==mxit, error = 0.0; end
end
return
  