function S = evaluate_shpfunc(coor,cx)
% function S = evaluate_shpfunc(coor,cx)
% Compute approach value for cx coordinate respect coor points using 1D
% Shape functions
% Universidad de Zaragoza - 2015
tam = numel(coor); % #number of nodes.
TOL = 1.0E-8; % Tolerance.
S = zeros(tam,1); % Allocating memory.
idx = 0; % Index of elemnt where cx is.
for i1=1:numel(coor)-1 % # Elements Loop to find with in
    if coor(i1)-TOL<=cx && coor(i1+1)>=cx
        idx = i1;
        break;
    end
end
% A = find(coor(coor>=cx+TOL)); 
% idx = A(end); % Idx is element containing cx.
if idx~=tam && idx~=0
    L = coor(idx+1)-coor(idx); % Linear approximation.
    S(idx+1) = (cx-coor(idx))/L;
    S(idx) = (coor(idx+1)-cx)/L;
elseif idx==0 % Not found any element
    S(1) = 1.0;
    disp('It is possible that discretization is not enough');
else % Last element
    S(tam) = 1.0;
end
return
