function elemstiffHyperelastic(coor)
% function elemstiff(coor)
% Computes s1, s2I and s3IJ matrices
% Universidad de Zaragoza - 2015
global s1 s2 s3
global num_iter_prev Gprev

nen = numel(coor);

% As in fem3DHyperelastic only new matrices s2I and s3IJ are calculated.
% s1 is calculated only the first time.
NIc = 0;
if num_iter_prev > 0
    NIc = size(s2,1); % Number of matrices s2 already calculated.
    if isempty(s2)==1, NIc = 0; end
end   
if NIc > 0
    % Save previously calculated matrices on auxiliary variables.
    s2_aux = s2; s3_aux = s3; 
end
%
% ALLOCATE MEMORY AND INITIALIZE
%
if num_iter_prev == 0
    s1 = sparse(nen,nen);
end
s2 = cell(num_iter_prev,1);
s3 = cell(num_iter_prev*num_iter_prev,1);
for i1=1:num_iter_prev, s2{i1} = sparse(nen,nen); end
for i1=1:num_iter_prev*num_iter_prev
    s3{i1} = sparse(nen,nen);
end
%
% ADD ALREADY CALCULATED MATRICES
%
if NIc>0
    s2(1:NIc) = s2_aux;    
    Incre = num_iter_prev-NIc;
    if Incre>0
        IndMat = zeros(NIc*NIc,NIc); IndMat(:,1) = [1:NIc*NIc]'; 
        for i1=2:NIc
            IndMat(:,i1) = IndMat(:,i1-1) + Incre.*ones(size(IndMat,1),1);
        end
        IndMat = reshape(IndMat(:),[NIc,NIc*NIc]);
        IM = IndMat(:,1:NIc+1:end);
        s3(IM(:)) = s3_aux;
    else
        s3 = s3_aux;
    end
end
%
% CALCULATE NEW MATRICES
%
X = coor(1:nen-1)'; Y = coor(2:nen)'; % Coordinates of elements.
L = Y - X; % Longitude of each  element for parametriced variable.
sg = [-1.0/sqrt(3.0) 1.0/sqrt(3.0)]; wg = ones(2,1); % Gauss points.
npg = numel(sg);
for i1=1:nen-1
    c = zeros(1,npg);
    N = zeros(nen,npg);
    c(1,:) = 0.5.*(1.0-sg).*X(i1) + 0.5.*(1.0+sg).*Y(i1);
    N(i1+1,:) = (c(1,:)-X(i1))./L(i1);
    N(i1,:) = (Y(i1)-c(1,:))./L(i1);
    for j1=1:npg
        if num_iter_prev == 0
            s1 = s1 + N(:,j1)*N(:,j1)'*0.5.*wg(j1).*L(i1);
        else
            for indI=NIc+1:num_iter_prev
                s2{indI}(:,:) = s2{indI}(:,:) + ...
         (N(:,j1)'*Gprev(:,indI))*N(:,j1)*N(:,j1)'*0.5.*wg(j1).*L(i1);
                for indJ=1:num_iter_prev
                    s3{(indI-1)*num_iter_prev+indJ}(:,:) = ...
                        s3{(indI-1)*num_iter_prev+indJ}(:,:) + ...
         (N(:,j1)'*Gprev(:,indI))*(N(:,j1)'*Gprev(:,indJ))...
         *N(:,j1)*N(:,j1)'*0.5.*wg(j1).*L(i1);
                end
            end            
            for indI=1:NIc
                for indJ=NIc+1:num_iter_prev
                    s3{(indI-1)*num_iter_prev+indJ}(:,:) = ...
                        s3{(indI-1)*num_iter_prev+indJ}(:,:) + ...
         (N(:,j1)'*Gprev(:,indI))*(N(:,j1)'*Gprev(:,indJ))...
         *N(:,j1)*N(:,j1)'*0.5.*wg(j1).*L(i1);
                end
            end
        end
    end
end
return