REM  **  Program ASTEREO4.BAS to make an auto-stereogram
REM  **     from a 4-bit depth-map. Depth-map is 4-bit BMP
REM  **     file, width a multiple of 32 pixels. User enters
REM  **     filename of depth-map, filename of auto-stereogram
REM  **     output, base-width of repeat, and step-width of
REM  **     change of depth. Program processes each row of
REM  **     depth-map to row of auto-stereogram.
REM
DECLARE SUB RDEPT4 ()
DECLARE SUB R4W1HE ()
DECLARE SUB WASOUT ()
DECLARE SUB CALCAS ()
DECLARE SUB CRERAN ()
DECLARE SUB REVBHEAD ()
DECLARE SUB PUTBYTE (I%)
DECLARE SUB PUTL (INTL&)
DECLARE SUB PUTI (INTE%)
REM      $DYNAMIC
         DIM SHARED BYTE AS STRING * 1
         COMMON SHARED VRANDOM(), VDEPTH(), VASOUT()
         COMMON SHARED FILEA$, FILEB$, BIWIDTH&, BIBITCOUNT%, BFOFFBI&
         COMMON SHARED MAXX%, MAXY%, MAXR%, MAXA%, BASEW%, STEPW%, YROW%

REM  **  Main program

START:   CLS
         PRINT " "
         PRINT " "
         PRINT " "
         PRINT " "
         PRINT "        |----------------------------------------------------------|"
         PRINT "        |     1-BIT AUTO-STEREOGRAM FROM 4-BIT DEPTH-MAP  ASTEREO4 |"
         PRINT "        |                                                          |"
         INPUT "        |     4-bit depth-map filename including .BMP extension ", FILEA$
         INPUT "        |     1-bit print filename including .BMP extension ", FILEB$
         INPUT "        |     Base-width of random sequence ", BASEW%
         INPUT "        |     Step-width of random sequence ", STEPW%
         INPUT "        |     Any key to continue, or X to exit ", GOEX$
         IF GOEX$ = "X" THEN END
         PRINT "        |                                                          |"
         PRINT "        |     Written in MS QBASIC by Alan Parkin Nov 2012         |"
         PRINT "        |----------------------------------------------------------|"
REM
         OPEN FILEA$ FOR BINARY AS #1
         OPEN FILEB$ FOR BINARY AS #2
         CALL R4W1HE
         MAXR% = BASEW% + (STEPW% * 16)
         DIM SHARED VRANDOM(-MAXR% TO MAXR%)
         DIM SHARED VDEPTH(MAXX%)
         DIM SHARED VASOUT(MAXX%)
         FOR YROW% = 0 TO MAXY%
            CALL CRERAN
            CALL RDEPT4
            CALL CALCAS
            CALL WASOUT
         NEXT YROW%
         CALL REVBHEAD
         CLOSE #1
         CLOSE #2
     
      END

REM $STATIC
         SUB CALCAS
REM  **  Sub-program to calculate auto-stereogram row VASOUT
REM         from depth-map row VDEPTH and random vector VRANDOM.

REM  **  Process first pixel in row
         CURD% = VDEPTH(0)
         CURW% = BASEW% + (CURD% * STEPW%)
         RPTR% = 0
         VASOUT(0) = VRANDOM(RPTR%)
         COUNTW% = 1

REM  **  Process rest of pixels in row
         FOR X% = 1 TO MAXX%
            CURD% = VDEPTH(X%)
            CURW% = BASEW% + (CURD% * STEPW%)
            UPDOWN% = VDEPTH(X%) - VDEPTH(X% - 1)
            IF UPDOWN% = 0 THEN
               RPTR% = RPTR% + 1
               IF RPTR% > CURW% THEN RPTR% = 0
               VASOUT(X%) = VRANDOM(RPTR%)
               COUNTW% = COUNTW% + 1
               IF COUNTW% > CURW% THEN COUNTW% = 0
            END IF
            IF UPDOWN% > 0 THEN
               RPTR% = RPTR% + (UPDOWN% * STEPW%)
               IF RPTR% > CURW% THEN RPTR% = 0
               VASOUT(X%) = VRANDOM(RPTR%)
               COUNTW% = COUNTW% + 1
               IF COUNTW% > CURW% THEN COUNTW% = 0
            END IF
            IF UPDOWN% < 0 THEN
               RPTR% = RPTR% - (UPDOWN% * STEPW%)
               IF RPTR% > CURW% THEN RPTR% = 0
               VASOUT(X%) = VRANDOM(RPTR%)
               COUNTW% = COUNTW% + 1
               IF COUNTW% > CURW% THEN COUNTW% = 0
            END IF
         NEXT X%

END SUB

         SUB CRERAN
REM  **  Subprogram to create a sequence of pixels in random
REM  **    vector VRANDOM, each set as intensity 0 or 1 at random.
REM
         FOR X% = -MAXR% TO MAXR%
            IF RND <= .5555 THEN INTEN% = 0 ELSE INTEN% = 1
            VRANDOM(X%) = INTEN%
         NEXT X%
        
END SUB

SUB PUTBYTE (ASCII%)
REM  **  Subprogram to put byte in file 2
REM
         BYTE = CHR$(ASCII%)
         PUT #2, SEEK(2), BYTE

END SUB

SUB PUTI (INTE%)
REM  **  Puts integer value passed into binary file as 2 bytes and increments
REM  **     pointer
         PUT$ = MKI$(INTE%)
         PUT #2, SEEK(2), PUT$

END SUB

SUB PUTL (INTL&)
REM  **  Puts long integer into binary file #2 as 4 bytes
REM
         PUT$ = MKL$(INTL&)
         PUT #2, SEEK(2), PUT$

END SUB

         SUB R4W1HE
REM  **  Subprogram R4W1HEAD to read header of 4-bit
REM  **     .BMP input file #1, and preliminary-write
REM  **     header and colour-table of 1-bit output file
REM  **     #2 (to be revised later).
REM
         L& = LOF(1)
         IF L& = 0 THEN
            CLOSE #1
            INPUT "Input file not found: hit any key to re-start ", OK
            END
         END IF
         GET #1, 1, MC%
         IF MC% <> 19778 THEN
            CLOSE #1
            INPUT "Input file not a BMP file ", OK
            END
         END IF
REM
REM  **  FileHeader group
REM
REM  **  Next bfType BM as 2-byte integer
         SEEK #2, 1
         BYTE = "B"
         PUT #2, SEEK(2), BYTE
         BYTE = "M"
         PUT #2, SEEK(2), BYTE
REM  **  Next bfSize file length in bytes, as long
         GET #1, 3, BFSIZEA&
         INTL& = BFSIZEA&
         CALL PUTL(INTL&)
REM  **  Next bfReserved1 and bfReserved2 as two integers, both = 0
         INTE% = 0
         CALL PUTI(INTE%)
         CALL PUTI(INTE%)
REM  **  Next bfOffBits header-plus-colortable length in bytes, as long
         GET #1, 11, BFOFFBI&
         INTL& = 62
         CALL PUTL(INTL&)
REM
REM  **  InfoHeader group
REM
REM  **  Next biSize infoheader length in bytes, as long
         GET #1, 15, BISIZEA&
         INTL& = BISIZEA&
         CALL PUTL(INTL&)
REM  **  Next biWidth image width in pixels, as long
         GET #1, 19, BIWIDTH&
         WIDTHA% = BIWIDTH&
         IF WIDTHA% MOD 32 <> 0 THEN
            INPUT "Image width not a multiple of 32 ", OK
            END
         END IF
         MAXX% = WIDTHA% - 1
         MAXA% = MAXX% / 2
         INTL& = BIWIDTH&
         CALL PUTL(INTL&)
REM  **  Next biHeight image height in pixels, as long
         GET #1, 23, BIHEIGHT&
         HEIGHT% = BIHEIGHT&
         IF BIWIDTH& * BIHEIGHT& > 35000 THEN
            INPUT "Input file too big ", OK
            END
         END IF
         MAXY% = HEIGHT% - 1
         INTL& = BIHEIGHT&
         CALL PUTL(INTL&)
REM  **  Next biPlanes = 1, as integer
         INTE% = 1
         CALL PUTI(INTE%)
REM  **  Next biBitCount bits per pixel, as integer
         GET #1, 29, BIBITCOUNT%
         IF BIBITCOUNT% <> 4 THEN
            INPUT "Input file not 4-bit ", OK
            END
         END IF
         INTE% = 1
         CALL PUTI(INTE%)
REM  **  Next biCompression = 0, as long
         INTL& = 0
         CALL PUTL(INTL&)
REM  **  Next biSizeImage image data length, as long
         GET #1, 35, BISIZEIMAGEA&
         INTL& = BISIZEIMAGEA&
         CALL PUTL(INTL&)
REM  **  Next biXPelsPerMeter = 0, as long
         INTL& = 0
         CALL PUTL(INTL&)
REM  **  Next biYPelsPerMeter = 0, as long
         INTL& = 0
         CALL PUTL(INTL&)
REM  **  Next biClrUsed = 0, as long
         INTL& = 0
         CALL PUTL(INTL&)
REM  **  Next biClrImportant = 0, as long
         INTL& = 0
         CALL PUTL(INTL&)
REM  **  Next 1-bit colour table
         BYTE = CHR$(0)
         PUT #2, 55, BYTE
         PUT #2, 56, BYTE
         PUT #2, 57, BYTE
         PUT #2, 58, BYTE
         BYTE = CHR$(255)
         PUT #2, 59, BYTE
         PUT #2, 60, BYTE
         PUT #2, 61, BYTE
         BYTE = CHR$(0)
         PUT #2, 62, BYTE

END SUB

            SUB RDEPT4
REM  **  Subprogram to read one row of 4-bit depth-map
REM  **     file #1 and load into depth vector VDEPTH.
REM  **     The data are 0 to 255.
REM
REM  **  Initialize vector VDEPTH
         FOR X% = 0 TO MAXX%
            VDEPTH(X%) = 0
         NEXT X%
REM  **  Get 4-bit depth data
         FBP& = BFOFFBI& + (YROW% * MAXA%)
         FOR XA% = 0 TO MAXA% - 1
            FBP& = FBP& + 1
            GET #1, FBP&, BYTE
REM  **  Convert BYTE to 2 nibbles, 1-character strings N1$ N2$
               HBY$ = HEX$(INT(ASC(BYTE)))
               IF LEN(HBY$) = 1 THEN
                  N1$ = "0"
                  N2$ = HBY$
                  ELSE
                  N1$ = MID$(HBY$, 1, 1)
                  N2$ = MID$(HBY$, 2)
               END IF
REM  **  Convert 2-nibble string of hex digits N1$+N2$
REM  **     to ASCII codes A1% and A2%
                    SELECT CASE N1$
                    CASE "0"
                       A1% = 0
                    CASE "1"
                       A1% = 1
                    CASE "2"
                       A1% = 2
                    CASE "3"
                       A1% = 3
                    CASE "4"
                       A1% = 4
                    CASE "5"
                       A1% = 5
                    CASE "6"
                       A1% = 6
                    CASE "7"
                       A1% = 7
                    CASE "8"
                       A1% = 8
                    CASE "9"
                       A1% = 9
                    CASE "A"
                       A1% = 10
                    CASE "B"
                       A1% = 11
                    CASE "C"
                       A1% = 12
                    CASE "D"
                       A1% = 13
                    CASE "E"
                       A1% = 14
                    CASE "F"
                       A1% = 15
                    END SELECT
                    SELECT CASE N2$
                    CASE "0"
                       A2% = 0
                    CASE "1"
                       A2% = 1
                    CASE "2"
                       A2% = 2
                    CASE "3"
                       A2% = 3
                    CASE "4"
                       A2% = 4
                    CASE "5"
                       A2% = 5
                    CASE "6"
                       A2% = 6
                    CASE "7"
                       A2% = 7
                    CASE "8"
                       A2% = 8
                    CASE "9"
                       A2% = 9
                    CASE "A"
                       A2% = 10
                    CASE "B"
                       A2% = 11
                    CASE "C"
                       A2% = 12
                    CASE "D"
                       A2% = 13
                    CASE "E"
                       A2% = 14
                    CASE "F"
                       A2% = 15
                    END SELECT
REM  **  Set ASCII A1% and A2% in next two positions
REM  **  of depth vector VDEPTH.
                 XB% = 2 * XA%
                 VDEPTH(XB%) = A1%
                 VDEPTH(XB% + 1) = A2%
         NEXT XA%
      
END SUB

SUB REVBHEAD
REM  **  Revises header of file #2 with values in bytes.
REM
REM  **  Next update bfSize length of file in bytes, as long
         INTL& = LOF(2)
         SEEK #2, 3
         CALL PUTL(INTL&)
REM  **  Next update biSizeImage length of image data in bytes, as long
         INTL& = LOF(2) - 62
         SEEK #2, 35
         CALL PUTL(INTL&)

END SUB

         SUB WASOUT
REM  **  Subprogram WASOUT to write data from auto-stereogram
REM  **     vector VASOUT to 1-bit .BMP file #2. Take VASOUT
REM  **     values 0 or 1 in groups of 8 and convert to byte.
REM  **     Finish row on a long (4-byte) boundary.
REM
         BYPERRO% = (((BIWIDTH& * 1) + 31) \ 32) * 4
         FOR BYCOUNT% = 0 TO (BYPERRO% - 1)
            ASCII% = 0
            FOR BICOUNT% = 0 TO 7
               INDEX% = 7 - BICOUNT%
               POWER2% = 2 ^ INDEX%
               X% = (BYCOUNT% * 8) + BICOUNT%
               INCREM% = VASOUT(X%) * POWER2%
               ASCII% = ASCII% + INCREM%
            NEXT BICOUNT%
            CALL PUTBYTE(ASCII%)
         NEXT BYCOUNT%

END SUB

