function[sys2,dim2] = add_end(sys,dim,sys2,dim2,N);
%
% [sys2,dim2] = add_end(sys,dim,sys2,dim2,N);
%
% Function to add state end-point constraint to MPC problem
%
%    x(k+N) = x_ss = D_ssx w(k+N)
%

[A,B1,B2,B3,C1,D11,D12,D13,C2,D1,D2,D3]=syst2ss(sys,dim);
[A,tB1,tB2,tB3,tC1,tD11,tD12,tD13,tC2,tD1,tD2,tD3,tC3,tD4,tD5,tD6,tC4,tD7,tD8,tD9]=syst2ss(sys2,dim2);
na  =dim(1);
nnb2=dim(3);
nnb3=dim(4);
nb1 =dim2(2);
nb2 =dim2(3);
nb3 =dim2(4);
nc1 =dim2(5);

Mss=[eye(na)-A -B3; -C2 -D3];
nns=rank(Mss);
[U,S,V]=svd(Mss);
nnu=size(U,1);
nnv=size(V,1);
U1=U(:,1:nns);
U2=U(:,nns+1:nnu);
V1=V(:,1:nns);
V2=V(:,nns+1:nnv);
S1=S(1:nns,1:nns);

Dssx= V1(1:na,:)*inv(S1)*U1'*[B2;D2];
Dssv= V1(na+1:na+nnb3,:)*inv(S1)*U1'*[B2;D2];

mat2=B2;
mat3=B3;
mata=eye(na);
for i=1:N-2
  mat2=[A*mat2 B2];
  mat3=[A*mat3 B3];
  mata=A*mata;
end;
mat2 = [mat2-[zeros(na,(N-2)*nnb3) Dssx] zeros(na,nnb2)];
mat3 = [mat3 zeros(na,nnb3)];

tC3   = [tC3;A*mata];
tD46  = [tD4 tD5 tD6;mata*B1 mat2 mat3];

sys2 = ss(A,[tB1 tB2 tB3],[tC1;tC2;tC3;tC4],[zeros(nc1,nb1+nb2+nb3); tD1 tD2 tD3;tD46;tD7 tD8 tD9],1);
dim2 = dim2+[0 0 0 0 0 0 na 0];

