function[sys2,dim2] = add_u(sys2,dim2,umax,sgn,descr);
% FOR IO systems:
%   [sysp,dimp] = add_u(sysp,dimp);
%   [sysp,dimp] = add_u(sysp,dimp,umax);
%   [sysp,dimp] = add_u(sysp,dimp,umax,sgn);
%   [sysp,dimp] = add_u(sysp,dimp,umax,sgn,'IO');
%   [sys,dim] = add_u(sys,dim);
%   [sys,dim] = add_u(sys,dim,umax);
%   [sys,dim] = add_u(sys,dim,umax,sgn);
%   [sys,dim] = add_u(sys,dim,umax,sgn,'IO');
%
% FOR IIO systems:
%   [sysp,dimp] = add_u(sysp,dimp,umax,sgn,'IIO');
%
% Function to add input constraint to standard problem
% Input constraint:
% For sgn =  1 :
%    u < |umax|
%
% For sgn = -1 :
%    -|umax| < u
%
% For sgn =  0 :
%    -|umax| < u < |umax|
%
% For an input output model  (descr == 'IO') or
% for an increment input output model (descr == 'IIO')
%
% DEFAULT VALUES
%      umax = 1
%      sgn  = 0
%      descr='IO'
%
% For umax=0 no input constraint is added
%
if nargin<2.5
  umax=1;
end;
if umax==0
  return;
end;
umax=abs(umax);
if nargin<3.5
  sgn=0;
end;
if nargin<4.5
  descr='IO';
end;
 
[tA,tB,tC,tD]=ssdata(sys2); 
 
na =dim2(1); 
nb1=dim2(2); 
nb2=dim2(3); 
nb3=dim2(4); 
nc1=dim2(5); 
nc2=dim2(6); 
nc3=dim2(7); 
nc4=dim2(8); 
 
tC13    = tC(1            :nc1+nc2+nc3    ,             :               ); 
tC4     = tC(1+nc1+nc2+nc3:nc1+nc2+nc3+nc4,             :               ); 
tD16    = tD(1            :nc1+nc2+nc3    ,             :               ); 
tD79    = tD(1+nc1+nc2+nc3:nc1+nc2+nc3+nc4,             :               ); 

umaxi=pinv(diag(umax));
 
if descr(1:2)=='IO'
  if sgn>-0.1
    tC4     = [tC4  ; zeros(nb3,na)         ];
    tD79    = [tD79 ; zeros(nb3,nb1+nb2) eye(nb3)*umaxi ];
    dim2(8) = dim2(8)+nb3;
  end;
  if sgn<0.1
    tC4     = [tC4  ; zeros(nb3,na)         ];
    tD79    = [tD79 ; zeros(nb3,nb1+nb2) -eye(nb3)*umaxi ];
    dim2(8) = dim2(8)+nb3;
  end;
  sys2    = ss(tA,tB,[tC13; tC4],[tD16 ; tD79],1);
else
  disp('Input constraint only implemented for IO systems.');
  disp(' Input constraint not added !!!');
end;
 
