function[sys2,dim2] = add_x(sys2,dim2,E,sgn);
%
%  [sys,dim] = add_x(sys,dim,E);
%  [sys,dim] = add_x(sys,dim,E,sgn);
%
% Function to add state constraint to standard problem
%
% State constraint:
% For sgn =  1 :
%    E x < 1         (inequality is taken element-wise)   
%
% For sgn = -1 :
%    - E x < 1       (inequality is taken element-wise)  
%
% For sgn =  0 :
%    -1 < E x < 1    (inequality is taken element-wise)     
%
% E is a matrix
%
%
% DEFAULT VALUES
%      sgn = 0
%
% for E=0 no output constraint is added
%
% NOTE: add_x cannot be used on the prediction model. 
%       (so add_x should be used before pred).  
%
if max(max(abs(E)))==0
  return;
end;

if nargin<3.5
  sgn=0;
end;
 
[A,tB,tC,tD]=ssdata(sys2);
 
na =dim2(1); 
nb1=dim2(2); 
nb2=dim2(3); 
nb3=dim2(4); 
nc1=dim2(5); 
nc2=dim2(6); 
nc3=dim2(7); 
nc4=dim2(8); 
ne =size(E,1);

tC1     = tC(1            :nc1            ,             :               );

tC13    = tC(1            :nc1+nc2+nc3    ,             :               ); 
tC4     = tC(1+nc1+nc2+nc3:nc1+nc2+nc3+nc4,             :               ); 
tD13    = tC(1            :nc1            ,             :               );
tD16    = tD(1            :nc1+nc2+nc3    ,             :               );
tD79    = tD(1+nc1+nc2+nc3:nc1+nc2+nc3+nc4,             :               ); 

if sgn>-0.1
 tC4     = [ tC4  ; E*A      ];
 tD79    = [ tD79 ; E*tB     ];
 dim2(8) = dim2(8)+ne;
end;
if sgn<0.1
 tC4     = [ tC4  ; -E*A       ];
 tD79    = [ tD79 ; -E*tB      ];
 dim2(8) = dim2(8)+ne;
end;
 
sys2    = ss(A,tB,[tC13; tC4],[tD16 ; tD79],1);
 
