function [tC,tD1,tD2,tD3]=blockmat(A,B1,B2,B3,C,D1,D2,D3,N)
% [tC,tD1,tD2,tD3]=blockmat(A,B1,B2,B3,C,D1,D2,D3,N)
%
% Function to compute the prediction block matrices:
%
%         | C     |                        | D1     |
%   tC  = | C*A   |                  tD1 = | C*B1   |
%         | C*A*A |                        | C*A*B1 |
%
%         | D2      0     0   |            | D3      0     0   |
%   tD2 = | C*B2    D2    0   |      tD2 = | C*B3    D3    0   |
%         | C*A*B2  C*B2  D2  |            | C*A*B3  C*B3  D3  |
%
% N = prediction horizon 
%


[ny,n3x]=size(D3);
[n1x,n2x]=size(D1'*D2);

tC  = C  ;
tD2 = D2 ;
tD3 = D3 ;
for i=1:N-1
%   tD2 = [ C*B2 zeros(ny,i*n3x); tC*A*B2 tD2 ];
  tD2 = [ D2 zeros(ny,i*n2x) ; tC*B2  tD2 ];
  tD3 = [ D3 zeros(ny,i*n3x) ; tC*B3  tD3 ];
  tC  = [  C  ; tC*A ];
end;

tD1 = [ D1 ; tC(1:(N-1)*ny,:)*B1 ];
