% Standard Predictive Control Toolbox.
% Version 5.6   January 8, 2008
%
% Common predictive control problems
%   gpc        - solves the generalized predictive control problem
%   gpc_ss     - solves the state space generalized predictive control problem
%   lqpc       - solves the linear quadratic predictive control problem
%
% Construction of process model
%   tf2syst    - transforms polynomial into SYSTEM format
%   imp2syst   - transforms impulse response model into SYSTEM format
%   ss2syst    - transforms state space model into the SYSTEM format
%   syst2ss    - transforms SYSTEM format into the state space model
%   io2iio     - transforms IO system into IIO system
%
% Formulation of standard predictive control problem
%   gpc2spc    - transforms GPC problem into an SPC problem
%   lqpc2spc   - transforms LQPC problem into an SPC problem
%   add_du     - function to add increment input constraint to SPC problem
%   add_u      - function to add input constraint to SPC problem
%   add_v      - function to add input constraint to SPC problem
%   add_y      - function to add output constraint to SPC problem
%   add_x      - function to add state constraint to SPC problem
%   add_nc     - function to add a prediction horizon to SPC problem
%   add_end    - function to add a state end-point constraint to SPC problem
%
% Standard predictive control problem
%   dgamma     - function makes the selection matrix
%   external   - function makes the external signal w from d and r
%   pred       - function makes a prediction model
%   contr      - function computes controller matrices for predictive controller
%   contrinf   - function computes controller matrices for inifinite horizon
%   lticon     - function computes the LTI optimal predictive controller
%   lticll     - function computes the LTI closed loop
%   simul      - function makes closed loop simulation with predictive controller
%   rhc        - function makes closed loop simulation in receding horizon mode
%
% Demonstrations of tuning
%   demogpc    - Tuning GPC controller 
%   demolqpc   - Tuning LQPC controller 
%

%       Copyright (c) 2008 by Ton van den Boom
