function[vv,HH,AA,bb]= contr(sys2,dim2,dim,dGam,ext);
%
% synopsis:
%   [vv,HH,AA,bb] = contr(sys2,dim2,dim,dGam);
%
% Computes matrices for predictive controller to transform it into
% a quadratic programming problem
%
% min   mu'*HH*mu 
% subject to  AA*mu < b
%
% where b  = bb*[1;xc(:,k);e(:,k);tw(:,k)];
%
% the output signal becomes 
%       v  = -F*xc(:,k) + De*e(:,k) + Dw*tw(:,k) + Dmu*mu
%          = vv*[xc(:,k);e(:,k);tw(:,k);mu(:,k)];
%
% where vv = [ -F De Dw Dmu];
%
%
% For unconstrained and for equality constrained case:
%       HH = [];   AA = [];  bb = [];
%
% and the output signal becomes 
%       v  = -F*xc(:,k) + De*e(:,k) + Dw*tw(:,k)
%          = vv*[xc(:,k);e(:,k);tw(:,k)];
%
% where vv = [ -F De Dw];
%
%

if nargin<4.5
  ext=0;
end;
%
% For ext=1 the extended matrices are computed.
%

nnb3 = dim(4);
na =dim2(1);
nb1=dim2(2);
nb2=dim2(3);
nb3=dim2(4);
nc1=dim2(5);
nc2=dim2(6);
nc3=dim2(7);
nc4=dim2(8);

%[A,tB1,tB2,tB3,tC1,tD11,tD12,tD13,tC2,tD1,tD2,tD3,...
%      tC3,tD4,tD5,tD6,tC4,tD7,tD8,tD9]=syst2ss(sys2,dim2);
[A,tB1,tB2,tB3,tC1,tD11,tD12,tD13,tC2,tD21,tD22,tD23,...
      tC3,tD31,tD32,tD33,tC4,tD41,tD42,tD43]=syst2ss(sys2,dim2);
                                        
if ext==0
  Ev   = [eye(nnb3) zeros(nnb3,nb3-nnb3)];
else
  Ev   = eye(nb3);
end;

if nc3>0
    [U33,S33,V33]=svd(tD33);
    [n33a,n33b]=size(tD33);
    tD33p = V33(:,n33a+1:n33b);
    tD33r = V33(:,1:n33a)*pinv(S33(1:n33a,1:n33a))*U33';
else
    tD33r=0;
    tD33p=1;
end;

dGam=diag(dGam);
if nc3==0
   %disp(' contr -- unconstrained case <<');
   [UXi,SXi,VXi]=svd(dGam*tD23);
   Xi = VXi*pinv(SXi)*UXi';
   F  =  Ev*(Xi*tC2);
   De = -Ev*(Xi*tD21);
   Dw = -Ev*(Xi*tD22);
else
   %disp(' contr -- equality constrained case <<');
   [UXi,SXi,VXi]=svd(dGam*tD23*tD33p);
   Xi = VXi*pinv(SXi)*UXi';
   F  = -Ev*(tD33p*Xi*tD23*tD33r*tC3-tD33p*Xi*tC2-tD33r*tC3);
   De =  Ev*(tD33p*Xi*tD23*tD33r*tD31-tD33p*Xi*tD21-tD33r*tD31);
   Dw =  Ev*(tD33p*Xi*tD23*tD33r*tD32-tD33p*Xi*tD22-tD33r*tD32);
end;
vv=[ -F, De, Dw];
HH = [];
AA = [];
bb = [];
if nc4>0   
    if nc3==0
      vv   = [vv Ev];
      HH   = 2*tD23'*dGam*tD23;
      AA   = tD43;
      bb   = [ ones(nc4,1) , -tC4 , -tD41 , -tD42 ] ;
      bb   = [ ones(nc4,1) , -(tC4-tD43*tD33p*Xi*tC2),...
             -(tD41-tD43*tD33p*Xi*tD21), -(tD42-tD43*tD33p*Xi*tD22)];
    else
      vv   = [vv Ev*tD33p];
      HH   = 2*tD33p'*tD23'*dGam*tD23*tD33p;
      AA   = tD43*tD33p;
      bb   = [ ones(nc4,1) ,...
         -(tC4-tD43*tD33r*tC3+tD43*tD33p*Xi*tD23*tD33r*tC3-tD43*tD33p*Xi*tC2),...
         -(tD41-tD43*tD33r*tD31+tD43*tD33p*Xi*tD23*tD33r*tD31-tD43*tD33p*Xi*tD21),... 
         -(tD42-tD43*tD33r*tD32+tD43*tD33p*Xi*tD23*tD33r*tD32-tD43*tD33p*Xi*tD22)];
    end;
end;
%max(max(abs(HH-HH')))
HH=(HH+HH')/2;
