function[vv]= contrinf(sys,sysp,dim,dimp,Nc,dGam,dGamss,ext);
%
% Computes matrices for predictive controller to transform it into
% a quadratic programming problem for infinte horizon
%
% synopsis:
%   [vv]= contrinf(sys,sysp,dim,dimp,Nc,dGamma,dGammass);
%
% Only the unconstrained case and equality constrained case are implemented:
%
%   vv = [ -F De Dw ];
%
%   v  = -F*xc(:,k) + De*e(:,k) + Dw*tw(:,k)
%      = vv*[xc(:,k);e(:,k);tw(:,k)];
%
%

if nargin<7.5
 ext=0;
 if nargin<6.5
   dGamss=[];
 end;
end;
%
% For ext=1 the extended matrices are computed.
%

% [tA,tB,tC,tD]=ssdata(sys2);
dGam=diag(dGam);
dGamss=diag(dGamss);

nnb2=dim(3);
nnb3=dim(4);
na =dimp(1);
nb1=dimp(2);
nb2=dimp(3);
nb3=dimp(4);
nc1=dimp(5);
nc2=dimp(6);
nc3=dimp(7);
nc4=dimp(8);

[tA,tB1,tB2,tB3,tC1,tD11,tD12,tD13,tC2,tD1,tD2,tD3,tC3,tD4,tD5,tD6,tC4,tD7,tD8,tD9]=syst2ss(sysp,dimp);
[A,B1,B2,B3,C1,D11,D12,D13,C2,D1,D2,D3,C3,D4,D5,D6,C4,D7,D8,D9]=syst2ss(sys,dim);

if ext==0
  Ev   = [eye(nnb3) zeros(nnb3,nb3-nnb3)];
else
  Ev   = eye(nb3);
end;

Mss=[eye(na)-A -B3; -C2 -D3];
nns=rank(Mss);
[U,S,V]=svd(Mss);
nnu=size(U,1);
nnv=size(V,1);
U1=U(:,1:nns);
U2=U(:,nns+1:nnu);
V1=V(:,1:nns);
V2=V(:,nns+1:nnv);
S1=S(1:nns,1:nns);

Dssx= V1(1:na,:)*inv(S1)*U1'*[B2;D2];
Dssv= V1(na+1:na+nnb3,:)*inv(S1)*U1'*[B2;D2];

if Nc==Inf
    X=inv(D3'*D3);
    bA=A-B3*X*D3'*C2;
    P=dare(bA,B3,C2'*(eye(nc2)-D3*X*D3')*C2,D3'*D3);
    F=inv(B3'*P*B3)*B3'*P*bA+X*D3'*C2;
    Dw=F*Dssx+Dssv;
    De=zeros(nb3,nb1);
    vv=[ -F, De, Dw];
    HH = [];
    ff = [];
    AA = [];
    bb = [];
    eig(P)
else
    [T,Lambda]=eig(tA);
    [dlambda,indlam]=sort(abs(diag(Lambda)));
    numstab=sum(dlambda<1-1e-4);
    T=T(:,indlam);
    Lambda=Lambda(indlam,indlam);
    bT=inv(T);
    Ts=[];
    Tu=[];
    bTs=[];
    bTu=[];
    if numstab>0
      As=Lambda(1:numstab,1:numstab);
      Ts=T(:,1:numstab);
      bTs=bT(1:numstab,:);
    end;
    ANc=A^(Nc-1);
    tB2=B2;
    tB3=B3;
    for i=1:Nc-1
      tB2=[A*tB2 B2];
      tB3=[A*tB3 B3];
    end;
    tB1=ANc*B1;
    tA=ANc*A;
    if numstab<na
      Tu=T(:,numstab+1:na);
      bTu=bT(numstab+1:na,:);
      Y=bTu*tB3;
      [UY,SY,VY]=svd(Y);
      [nYa,nYb]=size(Y);
      Yp  = VY(:,nYa+1:nYb);
      Yr  = VY(:,1:nYa)*pinv(SY(1:nYa,1:nYa))*UY';
      X   = dlyap(As',Ts'*C2'*dGamss*C2*Ts);
      bM  = bTs'*X*bTs;
      bH  = Yp*inv(Yp'*tB3'*bM*tB3*Yp+Yp'*tD3'*dGam*tD3*Yp)*Yp';
      Sw  = [zeros(nnb2,nb2-nnb2) eye(nnb2)];
      tmat=    [bH*tB3'*bM*tB3*Yr*bTu-Yr*bTu-bH*tB3'*bM+bH*tD3'*dGam*tD3*Yr*bTu  -bH*tD3'*dGam];
      mat = Ev*tmat;
      tF  =-tmat*[tA           ;tC2];
      tDe = tmat*[tB1          ;tD1];
      tDw = tmat*[(tB2-Dssx*Sw);tD2];
      tvv = [ -tF, tDe, tDw];
      F   =-mat*[tA           ;tC2];
      De  = mat*[tB1          ;tD1];
      Dw  = mat*[(tB2-Dssx*Sw);tD2];
      vv  = [ -F, De, Dw];
      HH  = [];
      ff  = [];
      AA  = [];
      bb  = [];

    else
      bM  = dlyap(A',C2'*dGamss*C2);
      bH = inv(tB3'*bM*tB3+tD3'*dGam*tD3);
      mat= Ev*[-bH*tB3'*bM -bH*tD3'*dGam];

      Sw=[zeros(nnb2,nb2-nnb2) eye(nnb2)];

      F  =-mat*[tA           ;tC2];
      De = mat*[tB1          ;tD1];
      Dw = mat*[(tB2-Dssx*Sw);tD2];
      vv=[ -F, De, Dw];
      HH = [];
      ff = [];
      AA = [];
      bb = [];

    end;
end;

