%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% Influence of Nc
% 
% File: demogpc7.m 
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
clf;
clc;
clear;
randn('state',0);

emag= 0*1e-2 ;

lensim=61;
t=0:lensim-1;
r  = [zeros(1,10) ones(1,100) zeros(1,100)];
di = 0*[zeros(1,25) 0.5 zeros(1,184)];
ei = emag*randn(1,lensim);
dumax = 0; % 0.10001 ;

apr = [0 0];

%%%  G(q)       %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 
ao = [1 -1.5 0.6];
bo = [0 -1 1.1];
a  = conv(ao,[1 -1]);
b  = [bo 0];
c  = [ao 0];
f  = [0 ao];

%%%  P(q)       %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

P = 1;
lambda=0.01   ;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 

Nm = 1;
Ncc= [1 2 3 25];
N = 25;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Nc = Ncc(1);

disp(['Nc=',int2str(Nc),' ']);
[y1b,du1b]=gpc(a,b,c,f,P,lambda,Nm,N,Nc,lensim,r,di,ei,dumax,apr);
u1b = cumsum(du1b);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Nc = Ncc(2);

disp(['Nc=',int2str(Nc),' ']);
t0=clock;
[y1,du1]=gpc(a,b,c,f,P,lambda,Nm,N,Nc,lensim,r,di,ei,dumax,apr);
time1=etime(clock,t0);
u1 = cumsum(du1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Nc = Ncc(3);

disp(['Nc=',int2str(Nc),' ']);
[y2b,du2b]=gpc(a,b,c,f,P,lambda,Nm,N,Nc,lensim,r,di,ei,dumax,apr);
u2b = cumsum(du2b);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Nc = Ncc(4);

disp(['Nc=',int2str(Nc),' ']);
t0=clock;
[y2,du2]=gpc(a,b,c,f,P,lambda,Nm,N,Nc,lensim,r,di,ei,dumax,apr);
time2=etime(clock,t0);
u2 = cumsum(du2);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[tt,rr] = stairs(t,r(:,1:lensim));
[tt,u1] = stairs(t,u1);
[tt,u1b] = stairs(t,u1b);
[tt,u2] = stairs(t,u2);
[tt,u2b] = stairs(t,u2b);

subplot(221);
plot(t,y1','c',t,y1b','r',tt,rr','--m');
title(['Nc=',int2str(Ncc(1)),' (red) , Nc=',int2str(Ncc(2)),' (cyan) ']);
xlabel('k -->');
ylabel('y -->');
grid; 
%-------------------------------------------------------------------------
subplot(222);
plot(tt,u1','c',tt,u1b','r');
title(['Nm=',int2str(Nm),' , N=',int2str(N)])
xlabel('k -->');
ylabel('u -->');
grid; 
disp('   ');
%-------------------------------------------------------------------------
subplot(223);
plot(t,y2','b',t,y2b','g',tt,rr','--m');
title(['Nc=',int2str(Ncc(3)),' (green) , Nc=',int2str(Ncc(4)),' (blue) ']);
xlabel('k -->');
ylabel('y -->');
grid; 
%-------------------------------------------------------------------------
subplot(224);
plot(tt,u2','b',tt,u2b','g');
xlabel('k -->');
ylabel('u -->');
grid; 
disp('   ');
 
