%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% Influence of Nm
% 
% File: demolqpc1.m 
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
clf;
clc;
clear;
randn('state',0);

emag= 0*1e-2 ;

lensim=61;
t=0:lensim-1;
%r  = [zeros(1,10) ones(1,100) zeros(1,100)];
do = [zeros(1,25) 5 zeros(1,185)];
eo = emag*randn(1,lensim);
xo = [[1;1;1] zeros(3,220)];
umax = 0; % 0.10001 ;
apr = 0;
rhc=0;

%%%  G(q)       %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 
ao = conv([1 -0.882],[1 -0.905]);
a = conv(ao,[1 -1]);
b = 0.029*[0 1 0.928 0];
c = [ao 0];
f = [0 ao];

[At,Ct,Bt,Dt]=tf2ss(b,a);
[At,Ct,Kt,DHt]=tf2ss(c,a);
[At,Ct,Lt,DFt]=tf2ss(f,a);
Ao=At';
Bo=Bt';
Co=Ct';
Ko=Kt';
Lo=Lt';

%%%  Q & R      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Q = Co*Co';
R = 0.01;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Nc = 2;
N  = 25;
Nm1=[ 1 8 16 23];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Nm = Nm1(1);

disp(['Nm=',int2str(Nm),' ']);

[y1b,u1b,x1b]=lqpc(Ao,Ko,Lo,Bo,Co,Q,R,Nm,N,Nc,lensim,xo,do,eo,umax,apr,rhc);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Nm = Nm1(2);

disp(['Nm=',int2str(Nm),' ']);
t0=clock;
[y1,u1,x1]=lqpc(Ao,Ko,Lo,Bo,Co,Q,R,Nm,N,Nc,lensim,xo,do,eo,umax,apr,rhc);
time1=etime(clock,t0);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%rr = r(:,1:lensim);

subplot(221);
%crit1=(y1-rr)*(y1-rr)'+lambda^2*du1*du1';
%figure(1);
stairs(t,[y1' y1b']);
title(['Nm=',int2str(Nm1(1)),' , ',int2str(Nm1(2)),'   N=',int2str(N),'   Nc=',int2str(Nc)]);
grid; 
subplot(222);
stairs(t,[u1' u1b']);
%title(['crit=',num2str(crit1),'   comp.time=',num2str(time1)]);
grid; 
disp('   ');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Nm = Nm1(3);

disp(['Nm=',int2str(Nm),' ']);
[y2b,u2b,x2b]=lqpc(Ao,Ko,Lo,Bo,Co,Q,R,Nm,N,Nc,lensim,xo,do,eo,umax,apr,rhc);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Nm = Nm1(4);

disp(['Nm=',int2str(Nm),' ']);
t0=clock;
[y2,u2,x2]=lqpc(Ao,Ko,Lo,Bo,Co,Q,R,Nm,N,Nc,lensim,xo,do,eo,umax,apr,rhc);
time2=etime(clock,t0);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%crit2=+lambda^2*du2*du2';
subplot(223);
stairs(t,[y2' y2b']);
title(['Nm=',int2str(Nm1(3)),' , ',int2str(Nm1(4)),'   N=',int2str(N),'   Nc=',int2str(Nc)]);
grid; 
subplot(224);
stairs(t,[u2' u2b']);
%title(['crit=',num2str(crit2),'   comp.time=',num2str(time2)]);
grid; 
disp('   ');
 
