function [tw]=external(apr,lensim,N,w1,w2,w3,w4,w5);
%
% tw=external(apr,lensim,N,w1,w2,w3,w4,w5);
%
% Function makes the external signal tw from d and r
%
% apr    = vector with flags for apriori knowledge on external signal.
% lensim = length simulation interval
% N      = prediction horizon
% wi     = is the row vector with external signal w_i(k) for i=1,...,5 
% 
% tw     = the row vector with predictions of the external signal w(k).

if N==Inf
 N=1;
end;

nrg=nargin-3;
nwv=zeros(nrg,1);
flgtot=[];
w=[]; 
nwvold=0;
for i=1:nrg
  eval(['wi=w',int2str(i),';']);  
  [nwi,lenwi]=size(wi);
  if lenwi<lensim+N
    wi=[wi , wi(:,lenwi)*ones(1,lensim+N-lenwi)];
  end;
  nwv(i)=sum(nwv)+nwi;
  w=[w;wi(:,1:lensim+N)];
  flgtot=[flgtot;apr(i)*ones(nwi,1)];
  nmvold=nwv(i);
end;
nw=nmvold;

ind1=((1:nw)'*ones(1,N))+(flgtot*(0:N-1)*nw);
ind2=ind1(:);
ind3=ind2*ones(1,lensim)+ones(N*nw,1)*(0:lensim-1)*nw;
tw=w(ind3);
