function[y,du,sys,dim,vv,HH,AA,bb]=gpc(ai,bi,ci,fi,P,lambda,Nm,N,Nc,lensim,r,di,ei,dumax,apr,rhc);
% [y,du]=gpc(ai,bi,ci,fi,P,lambda,Nm,N,Nc,lensim,r,di,ei,dumax,apr,rhc);
% [y,du,sys,dim,vv,HH,AA,bb]=gpc(ai,bi,ci,fi,P,lambda,Nm,N,Nc,lensim,r,di,ei,dumax,apr,rhc);
%
% Solves the generalized predictive control problem
%
%   ai(q)y(k) = bi(q)du(k) + ci(q)ei(k) + fi(q)di(k)
%
%   min sum |y_p(k)-r(k)|^2 + lambda*|du|^2
%
%   subject to  |du(k)| < dumax
%
%   Nm = minimum cost horizon
%   N  = prediction horizon
%   Nc = control horizon
%   lensim = length simulation interval
%
%   apr = [apr(1) apr(2)]; 
%   apr(1)=1 : reference signal d(k+j) is a priori known for j>0
%   apr(1)=0 : reference signal d(k+j) is not a priori known for j>0
%   apr(2)=1 : reference signal r(k+j) is a priori known for j>0
%   apr(2)=0 : reference signal r(k+j) is not a priori known for j>0
%
%   rhc=0 : the simulation is done in simulation mode
%   rhc=1 : the simulation is done in a receding horizon mode
%           (for receding horizon mode: Press ENTER button each time-step)
%
%   The output variables sys, dim and vv can be used as input variables for the functions
%   lticll and lticon

if nargin<15.5
  rhc=0;
  if nargin<14.5
    apr=[1 1];
    if nargin<13.5
      dumax=0;
    end
  end;
end;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%     Check sizes
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

ndum=zeros(5,1);
[na1,na2]=size(ai);
[nb1,nb2]=size(bi);
[nc1,nc2]=size(ci);
[nf1,nf2]=size(fi);
[nP1,nP2]=size(P);

if na1~=1
 disp('variable ai should be a polynomial');
 return;
end;
if nb1~=1
 disp('variable bi should be a polynomial');
 return;
end;
if nc1~=1
 disp('variable ci should be a polynomial');
 return;
end;
if nf1~=1
 disp('variable fi should be a polynomial');
 return;
end;
if nP1~=1
 disp('variable P should be a polynomial');
 return;
end;

if nb2~=na2
 disp('polynomial ai and bi must have same order');
 return;
end;
if nc2~=na2
 disp('polynomial ai and ci must have same order');
 return;
end;
if nf2~=na2
 disp('polynomial ai and fi must have same order');
 return;
end;

if Nm>N
 disp('minumum cost horizon Nm must be smaller or equal to N');
 return;
end;

if Nc>N
 disp('minumum cost horizon Nc must be smaller or equal to N');
 return;
end;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

HH=[];
AA=[];
bb=[];

P=P/sum(P);
[Ap,Bp,Cp,Dp]=tf2ss(P,[1 zeros(1,length(P)-1)]);
sysP = ss(Ap,Bp,Cp,Dp,1);

na = length(ai)+length(P)-2;

du = zeros(1,lensim);
y  = zeros(1,lensim); 
x  = zeros(na,lensim+1);
xc = zeros(na,lensim+1);
 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if N<Inf
  disp('  ');
  disp(' tf2syst  <<');     [Gi,dimi]   = tf2syst(ai,bi,ci,fi);
  disp(' gpc2spc  <<');     [sys,dim]   = gpc2spc(Gi,dimi,sysP,lambda);
  disp(' external <<');     tw          = external(apr,lensim,N,di,r(2:end));
  disp(' dgamma   <<');     [dGam]      = dgamma(Nm,N,dim);
  disp(' pred     <<');     [sysp,dimp] = pred(sys,dim,N);
  if Nc<N+1;
    disp(' add_Nc   <<');   [sysp,dimp] = add_nc(sysp,dimp,dimi,Nc);
  end;
  disp(' add_du   <<');     [sysp,dimp] = add_du(sysp,dimp,dumax,0);
  if rhc==1
    disp(' rhc      <<');   [x,xc,y,du] = rhc(sys,sys,sysp,dim,dimp,dGam,N,x,xc,y,du,tw,ei,1,lensim);
  else
    disp(' contr    <<');   [vv,HH,AA,bb] = contr(sysp,dimp,dim,dGam);
    disp(' simul    <<');   [x,xc,y,du,error] = simul(sys,sys,dim,N,x,xc,y,du,tw,ei,1,lensim,vv,HH,AA,bb);
  end;
else
  if dumax==0
    disp('  ');
    disp(' tf2syst  <<');     [Gi,dimi]   = tf2syst(ai,bi,ci,fi);
    disp(' gpc2spc  <<');     [sys,dim]   = gpc2spc(Gi,dimi,sysP,lambda);
    dGamss=[];
    if Nc<Inf
      disp(' external <<');     tw          = external(apr,lensim,Nc,di,r(2:end));
      disp(' dgamma   <<');     [dGam,dGamss] = dgamma(1,Nc,dim);
      disp(' pred     <<');     [sysp,dimp] = pred(sys,dim,Nc);
    else
      disp(' external <<');     tw          = external(apr,lensim,N,di,r(2:end));
      sysp=sys;
      dimp=dim;
      disp(' dgamma   <<');     [dGam]      = dgamma(1,1,dim);
    end;
    if Nc<Inf;
      disp(' add_Nc   <<');   [sysp,dimp] = add_nc(sysp,dimp,dimi,Nc);
    end;
    disp(' add_du   <<');     [sysp,dimp] = add_du(sysp,dimp,dumax,0);
    if rhc==1
      disp(' rhc      <<');   [x,xc,y,du] = rhc(sys,sys,sysp,dim,dimp,dGam,Nc,x,xc,y,du,tw,ei,1,lensim);
    else
      disp(' contrinf <<');   [vv] = contrinf(sys,sysp,dim,dimp,Nc,dGam,dGamss);
      disp(' simul    <<');   [x,xc,y,du,error] = simul(sys,sys,dim,Nc,x,xc,y,du,tw,ei,1,lensim,vv);
  end;
  else
    disp('Constrained infinite horizon GPC has not been implemented yet!!');
  end;
end;
