function[y,u,x,sys,dim,vv,HH,AA,bb]=lqpc(Ao,Ko,Lo,Bo,Co,DH,DF,Q,R,Nm,N,Nc,lensim,xo,do,eo,umax,apr,rhc);
%
% [y,u,x]=lqpc(Ao,Ko,Lo,Bo,Co,DH,DF,Q,R,Nm,N,Nc,lensim,xo,do,eo,umax,apr,rhc);
% [y,u,x,sys,dim,vv,HH,AA,bb]=lqpc(Ao,Ko,Lo,Bo,Co,DH,DF,Q,R,Nm,N,Nc,lensim,xo,do,eo,umax,apr,rhc);
%
% Solves the linear quadratic predictive control problem
%
%   x(k+1) = Ao x(k) + Ko eo(k) + Lo do(k) + Bo u(k)
%   y(k)   = Co x(k) + DH eo(k) + DF do(k)
%
%   min sum x^TQx + u^TRu
%
%   subject to  |u(k)| < umax
%
%   Nm = minimum cost horizon
%   N  = prediction horizon
%   Nc = control horizon
%
%   lensim = length simulation interval
%
%   xo = initial state x(1)
%
%   apr=1 : reference signal d(k+j) is a priori known for j>0
%   apr=0 : reference signal d(k+j) is not a priori known for j>0
%
%   rhc=1   : the simulation is done in a receding horizon mode
%
%   The output variables sys, dim and vv can be used as input variables for the functions
%   lticll and lticon

if nargin<18.5
  rhc=0;
  if nargin<17.5
    apr=1;
    if nargin<16.5
      umax=0;
    end
  end;
end;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%     Check sizes
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

ndum=zeros(5,1);
[nA1,nA2]=size(Ao);
[nB1,nB2]=size(Bo);
[nC1,nC2]=size(Co);
[nK1,nK2]=size(Ko);
[nL1,nL2]=size(Lo);
[nQ1,nQ2]=size(Q);
[nR1,nR2]=size(R);
[nDH1,nDH2]=size(DH);
[nDF1,nDF2]=size(DF);

if nA1~=nA2
 disp('matrix A must be square');
 return;
end;
if nB1~=nA1
 disp('matrix A and B must have same number of rows');
 return;
end;
if nC2~=nA1
 disp('matrix A and C must have same number of columns');
 return;
end;
if nK1~=nA1
 disp('matrix A and K must have same number of rows');
 return;
end;
if nK2~=nC1
 disp('# rows of matrix C must equal to # columns of matrix K');
 return;
end;
if nL1~=nA1
 disp('matrix A and L must have same number of rows');
 return;
end;
if nDH1~=nC1
 disp('# rows of matrix DH must equal to # rows of matrix Ci');
 return;
end;
if nDF1~=nC1
 disp('# rows of matrix DF must equal to # rows of matrix Ci');
 return;
end;
if nDH1~=nDH2
 disp('matrix DH must be square');
 return;
end;
if nDF2~=nL2
 disp('# columns of matrix DF must equal to # columns of matrix Li');
 return;
end;

if Nm>N
 disp('minumum cost horizon Nm must be smaller or equal to N');
 return;
end;

if Nc>N
 disp('minumum cost horizon Nm must be smaller or equal to N');
 return;
end;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

HH=[];
AA=[];
bb=[];

[na,nK]=size(Ko);
[nL,nB]=size(Lo'*Bo);

% dimo = [na nK nL nB nK ];
% Go=ss(Ao,[Ko Lo Bo],Co,[eye(nK) zeros(nK,nL+nB)],1);

% N=N;

u  = zeros(1,lensim);
y  = zeros(1,lensim); 
x  = [xo,zeros(na,lensim)];
xc = [xo,zeros(na,lensim)];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 

disp('  '); 
disp(' ss2syst  <<');     [Go,dimo]   = ss2syst(Ao,Ko,Lo,Bo,Co,1,0,0);
disp(' lqpc2spc <<');     [sys,dim]   = lqpc2spc(Go,dimo,Q,R);
disp(' external <<');     tw          = external(apr,lensim,N,do);
disp(' dgamma   <<');     [dGam]      = dgamma(Nm,N,dim);
disp(' pred     <<');     [sysp,dimp] = pred(sys,dim,N);
if Nc<N
  disp(' add_Nc   <<');   [sysp,dimp] = add_nc(sysp,dimp,dimo,Nc,'IO');
end;
disp(' add_u    <<');     [sysp,dimp] = add_u(sysp,dimp,umax,0);
if rhc==0
  disp(' contr    <<');   [vv,HH,AA,bb] = contr(sysp,dimp,dim,dGam)
  disp(' simul    <<');   [x,xc,y,u,error] = simul(sys,sys,dim,N,x,xc,y,u,tw,eo,1,lensim,vv,HH,AA,bb);
else
  disp(' rhc      <<');   [x,xc,y,u] = rhc(sys,sys,sysp,dim,dimp,dGam,N,x,xc,y,u,tw,eo,1,lensim);
end;
