function[sys,dim]=lqpc2spc(Go,dimo,Q,R);
%
% [sys,dim]=lqpc2spc(Go,dimo,Q,R);
%
% Transforms LQPC problem into a standard predictive control problem
%
% System Go is an IO model:
%
%   x(k+1) = Ao x(k) + Ko eo(k) + Lo do(k) + Bo u(k)
%   y(k)   = Co x(k) + DH eo(k) + DF do(k)
%
% System sys:
%
%   x(k+1) = A  x(k)  + B1  e(k) + B2  w(k) + B3  v(k)
%   y(k)   = C1 x(k)  + D11 e(k) + D12 w(k)
%   z(k)   = C2 x(k)  + D21 e(k) + D22 w(k) + D23 v(k)
%
% z(k) = [ sqrt(Q) x(k+1) ]
%        [ sqrt(R) u(k)   ]
%
%

[Ao,KLBo,Co,DHF]= ssdata(Go);
na =dimo(1);
nb1=dimo(2);
nb2=dimo(3);
nb3=dimo(4);
nc1=dimo(5);
Ko = KLBo(:,1        :nb1        );
Lo = KLBo(:,1+nb1    :nb1+nb2    );
Bo = KLBo(:,1+nb1+nb2:nb1+nb2+nb3);
DH = DHF(:,1        :nb1        );
DF = DHF(:,1+nb1    :nb1+nb2    );

[UQ,SQ,VQ]=svd((Q+Q')/2);
[UR,SR,VR]=svd((R+R')/2);
Qs= UQ*diag(sqrt(diag(SQ)))*UQ';
Rs= UR*diag(sqrt(diag(SR)))*UR';

A  = Ao;
B1 = Ko;
B2 = Lo;
B3 = Bo;
C1 = Co;
C2 = [Qs*Ao   ; zeros(nb3,na )];
D11 = DH;
D12 = DF;
D13 = zeros(nc1,nb3);
D21 = [Qs*Ko; zeros(nb3,nb1)];
D22 = [Qs*Lo; zeros(nb3,nb2)];
D23 = [Qs*Bo; Rs*eye(nb3)];

na=size(A,1);

Asys = A;
Bsys=[B1 B2 B3];
Csys=[C1;C2];
Dsys=[D11 D12 D13; D21 D22 D23];

sys = ss(Asys,Bsys,Csys,Dsys,1);
dim = [na nb1 nb2 nb3 nc1 na+nb3 0 0];


