function[G,dim]=ss2syst(A,B1,B2,B3,C1,D11,D12,D13,C2,D21,D22,D23,...
                   C3,D31,D32,D33,C4,D41,D42,D43);
%
%  [G,dim]=ss2syst(A,B1,B2,B3,C1,D11,D12,D13);
%  [G,dim]=ss2syst([A,B1,B2,B3,C1,D11,D12,D13,C2,D21,D22,D23);
%  [G,dim]=ss2syst([A,B1,B2,B3,C1,D11,D12,D13,C2,D21,D22,D23,...
%                   C3,D31,D32,D33,C4,D41,D42,D43);
%  [Gp,dimp]=ss2syst([A,tB1,tB2,tB3,tC1,tD11,tD12,tD13,tC2,tD21,tD22,tD23,...
%                   tC3,tD31,tD32,tD33,tC4,tD41,tD42,tD43);
%
% Function transforms state space model into the SYSTEM format
%
% Input system:
%    x(k+1) = A  x(k) + B1  e(k) + B2  w(k) + B3  v(k)
%    y(k)   = C1 x(k) + D11 e(k) + D12 w(k) + D13 v(k)
%    z(k)   = C2 x(k) + D21 e(k) + D22 w(k) + D23 v(k)
%    phi(k) = C3 x(k) + D31 e(k) + D32 w(k) + D33 v(k)
%    psi(k) = C4 x(k) + D41 e(k) + D42 w(k) + D43 v(k)
%
% Output system:
%
%    G   = [ A   B1   B2   B3  ]
%          [ C1  D11  D12  D13 ]
%          [ C2  D21  D22  D23 ]
%          [ C3  D31  D32  D33 ]
%          [ C4  D41  D42  D43 ]
%
%    dim = [ nA nB1 nB2 nB3 nC1 nC2 nC3 nC4 ]
%
% (Typically D13=0)
%

nC2=0;
nC3=0;
nC4=0;

[nC1,nA]=size(C1);
nB1=size(B1,2);
nB2=size(B2,2);
nB3=size(B3,2);

if nargin<5.5
   D11=1; 
   D12=0;
   D13=0;
end;

if D11==1 
   D11=eye(nB1); 
end;

if D12==0
   D12=zeros(nB1,nB2); 
end;

if D13==0
   D13=zeros(nB1,nB3); 
end;

B=[B1,B2,B3];
C=[C1];
D=[D11 D12 D13]; 

if nargin>8.5
   C=[C;C2];
   D=[D;D21 D22 D23];
   nC2=size(C2,1);
   if nargin>12.5
     C=[C;C3;C4];
     D=[D;D31 D32 D33;D41 D42 D43];
     nC3=size(C3,1);
     nC4=size(C4,1);
  end;
end;
   
G   = ss(A,B,C,D,1);
dim = [nA nB1 nB2 nB3 nC1 nC2 nC3 nC4];

