function [A,B1,B2,B3,C1,D11,D12,D13,C2,D21,D22,D23,C3,D31,...
          D32,D33,C4,D41,D42,D43]=syst2ss(sys,dim);
%
% [A,B1,B2,B3,C1]=syst2ss(sys,dim);
% [A,B1,B2,B3,C1,D11,D12,D13]=syst2ss(sys,dim);
% [A,B1,B2,B3,C1,D11,D12,D13,C2,D21,D22,D23]=syst2ss(sys,dim);
% [A,B1,B2,B3,C1,D11,D12,D13,C2,D21,D22,D23,C3,D31,...
%         D32,D33,C4,D41,D42,D43]=syst2ss(sys,dim);
% [A,tB1,tB2,tB3,tC1,tD11,tD12,tD13,tC2,tD21,tD22,tD23,tC3,...
%         tD31,tD32,tD33,tC4,tD41,tD42,tD43]=syst2ss(sysp,dimp);
%
% Function retrieves state space model from the SYSTEM format
%
% Input system:
%
%    G    = [ A  B1  B2  B3  ]
%           [ C1 D11 D12 D13 ]
%           [ C2 D21 D22 D23 ]
%           [ C3 D31 D32 D33 ]
%           [ C4 D41 D42 D43 ]
%
%    dim  = [ nA nB1 nB2 nB3 nC1 nC2 nC3 nC4 ]
%
% Output system:
%
%    x(k+1)  = A  x(k) + B1  e(k) + B2  w(k) + B3  v(k)
%    y(k)    = C1 x(k) + D11 e(k) + D12 w(k) + D13 v(k)
%    z(k)    = C2 x(k) + D21 e(k) + D22 w(k) + D23 v(k)
%    phi(k)  = C3 x(k) + D31 e(k) + D32 w(k) + D33 v(k)
%    psi(k)  = C4 x(k) + D41 e(k) + D42 w(k) + D43 v(k)
%
% (Typically D13=0)
%

na =dim(1);
nb1=dim(2);
nb2=dim(3);
nb3=dim(4);
nc1=dim(5);
nc2=dim(6);
nc3=dim(7);
nc4=dim(8);

[A,B,C,D]=ssdata(sys);
B1  = B(             :               ,1            :nb1            );
B2  = B(             :               ,1+nb1        :nb1+nb2        );
B3  = B(             :               ,1+nb1+nb2    :nb1+nb2+nb3    );
C1  = C(1            :nc1            ,             :               );

if nargout>5.5 
 D11 = D(1            :nc1            ,1            :nb1            );
 D12 = D(1            :nc1            ,1+nb1        :nb1+nb2        );
 D13 = D(1            :nc1            ,1+nb1+nb2    :nb1+nb2+nb3    );
 if nargout>8.5
  C2  = C(1+nc1        :nc1+nc2        ,             :               );
  D21 = D(1+nc1        :nc1+nc2        ,1            :nb1            );
  D22 = D(1+nc1        :nc1+nc2        ,1+nb1        :nb1+nb2        );
  D23 = D(1+nc1        :nc1+nc2        ,1+nb1+nb2    :nb1+nb2+nb3    );
  if nargout>12.5
    C3  = C(1+nc1+nc2    :nc1+nc2+nc3    ,             :               );
    D31 = D(1+nc1+nc2    :nc1+nc2+nc3    ,1            :nb1            );
    D32 = D(1+nc1+nc2    :nc1+nc2+nc3    ,1+nb1        :nb1+nb2        );
    D33 = D(1+nc1+nc2    :nc1+nc2+nc3    ,1+nb1+nb2    :nb1+nb2+nb3    );
    if nargout>15.5
      C4  = C(1+nc1+nc2+nc3:nc1+nc2+nc3+nc4,             :               );
      D41 = D(1+nc1+nc2+nc3:nc1+nc2+nc3+nc4,1            :nb1            );
      D42 = D(1+nc1+nc2+nc3:nc1+nc2+nc3+nc4,1+nb1        :nb1+nb2        );
      D43 = D(1+nc1+nc2+nc3:nc1+nc2+nc3+nc4,1+nb1+nb2    :nb1+nb2+nb3    );
    end;
  end;
 end;
 else 
  D11 = eye(nc1); 
  D12 = zeros(nc1,nb2);  
  D13 = zeros(nc1,nb3); 
end;
