function solution62c

% define beta via the constants in front of r
beta1 = [2 1 0 0 0 0 0 0]
beta2 = [2*(1/2).^[0:5]]

% and evaluate alpha
gamma1 = cumsum(beta1)
gamma2 = cumsum(beta2)
for N=3:6
 a1 = alpha(gamma1,N);
 a2 = alpha(gamma2,N);
 fprintf('N=%d: alpha=%8.5f, tilde-alpha=%8.5f\n',N,a1,a2);
end;



% implementation of alpha-formula (6.19)
function a=alpha(gamma,N)

  a = 1 - (gamma(N)-1) * prod(gamma(2:N)-ones(size(gamma(2:N)))) / ...
          (prod(gamma(2:N)) - prod(gamma(2:N)-ones(size(gamma(2:N)))));
