function[sys2,dim2] = add_du(sys2,dim2,dumax,sgn,descr);
% FOR IIO systems:
%   [sysp,dimp] = add_du(sysp,dimp);
%   [sysp,dimp] = add_du(sysp,dimp,dumax);
%   [sysp,dimp] = add_du(sysp,dimp,dumax,sgn);
%   [sysp,dimp] = add_du(sysp,dimp,dumax,sgn,'IIO');
%   [sys,dim] = add_du(sys,dim);
%   [sys,dim] = add_du(sys,dim,dumax);
%   [sys,dim] = add_du(sys,dim,dumax,sgn);
%   [sys,dim] = add_du(sys,dim,dumax,sgn,'IIO');
%
% FOR IO systems:
%   [sysp,dimp] = add_du(sysp,dimp,dumax,sgn,'IO');
%
% Function to add increment input constraint to standard problem
%
% For sgn =  1 :
%    du < |dumax|
%
% For sgn = -1 :
%    -|dumax| < du
%
% For sgn =  0 :
%    -|dumax| < du < |dumax|
%
% For an input output model  (descr == 'IO') or
% for an increment input output model (descr == 'IIO')
%
% DEFAULT VALUES
%      dumax = 1 ;
%      sgn   = 0;
%      descr ='IIO';
%
% for dumax=0 no incrment-input constraint is added
%

if dumax==0
  return;
end;

if nargin<2.5
  dumax=1;
end;
if nargin<3.5
  sgn=1;
end;
if nargin<4.5
  descr='IIO';
end;
 
[tA,tB,tC,tD]=ssdata(sys2); 
 
na =dim2(1); 
nb1=dim2(2); 
nb2=dim2(3); 
nb3=dim2(4); 
nc1=dim2(5); 
nc2=dim2(6); 
nc3=dim2(7); 
nc4=dim2(8); 
 
tC13    = tC(1            :nc1+nc2+nc3    ,             :               ); 
tC4     = tC(1+nc1+nc2+nc3:nc1+nc2+nc3+nc4,             :               );
tD13    = tD(1            :nc1+nc2+nc3    ,             :               ); 
tD4     = tD(1+nc1+nc2+nc3:nc1+nc2+nc3+nc4,             :               ); 
 
dumaxi=pinv(diag(dumax));

if descr(1:2)=='II'
  if sgn>-0.1
   tC4     = [tC4  ; zeros(nb3,na)         ];
   tD4     = [tD4 ; zeros(nb3,nb1+nb2) eye(nb3)*dumaxi ];
   dim2(8) = dim2(8)+nb3;
  end;
  if sgn<0.1
   tC4     = [tC4  ; zeros(nb3,na)         ];
   tD4     = [tD4 ; zeros(nb3,nb1+nb2) -eye(nb3)*dumaxi ];
   dim2(8) = dim2(8)+nb3;
 end;
 sys2    = ss(tA,tB,[tC13; tC4],[tD13 ; tD4],1);
else
  disp('Increment input constraint only implemented for IIO systems.');
  disp(' Increment input constraint not added !!!');
end;
 
