function[sys2,dim2] = add_nc(sys2,dim2,dim,Nc,descr);
% [sys2,dim2] = add_nc(sys2,dim2,dim,Nc,descr);
%
% Function to add a prediction horizon to standard problem
%
% For an increment input output model (descr == 'IIO')
%     v(k+j) = 0          for j >= Nc
%
% For an input output model  (descr == 'IO')
%     v(k+j) = v(k+Nc-1)    for j >= Nc
%
% DEFAULT VALUES
%      descr='IIO';
%
% Note: dumax > 0 !!!!!
%
%

if nargin<4.5
  descr='IIO';
end;

[tA,tB,tC,tD]=ssdata(sys2);

nnb3 = dim(4);
na =dim2(1);
nb1=dim2(2);
nb2=dim2(3);
nb3=dim2(4);
nc1=dim2(5);
nc2=dim2(6);
nc3=dim2(7);
nc4=dim2(8);

tC12  = tC(1            :nc1+nc2        ,             :               );
tC3   = tC(1+nc1+nc2    :nc1+nc2+nc3    ,             :               );
tC4   = tC(1+nc1+nc2+nc3:nc1+nc2+nc3+nc4,             :               );
tD13  = tD(1            :nc1+nc2        ,             :               );
tD46  = tD(1+nc1+nc2    :nc1+nc2+nc3    ,             :               );
tD79  = tD(1+nc1+nc2+nc3:nc1+nc2+nc3+nc4,             :               );

if descr(1:2)=='II'
  tD6   = [zeros(nb3-Nc*nnb3,Nc*nnb3) eye(nb3-Nc*nnb3)];
  tC3   = [tC3  ; zeros(nb3-Nc*nnb3,na)         ];
  tD46  = [tD46 ; zeros(nb3-Nc*nnb3,nb1+nb2) tD6];
  sys2 = ss(tA,tB,[tC12; tC3 ; tC4],[tD13 ; tD46 ; tD79],1);
  dim2 = dim2+[0 0 0 0 0 0 nb3-Nc*nnb3 0];
else
  tD61  = [zeros(nb3-Nc*nnb3,Nc*nnb3) eye(nb3-Nc*nnb3)];
  tD62  = [zeros(nb3-Nc*nnb3,(Nc-1)*nnb3) eye(nb3-Nc*nnb3) zeros(nb3-Nc*nnb3,nnb3)];
  tC3   = [tC3  ; zeros(nb3-Nc*nnb3,na)         ];
  tD46  = [tD46 ; zeros(nb3-Nc*nnb3,nb1+nb2) tD61-tD62];
  sys2 = ss(tA,tB,[tC12; tC3 ; tC4],[tD13 ; tD46 ; tD79],1);
  dim2 = dim2+[0 0 0 0 0 0 nb3-Nc*nnb3 0];
end;


