function[sys2,dim2] = add_v(sys2,dim2,vmax,sgn);
%   [sysp,dimp] = add_v(sysp,dimp);
%   [sysp,dimp] = add_v(sysp,dimp,vmax);
%   [sysp,dimp] = add_v(sysp,dimp,vmax,sgn);
%   [sys,dim] = add_v(sys,dim);
%   [sys,dim] = add_v(sys,dim,vmax);
%   [sys,dim] = add_v(sys,dim,vmax,sgn);
%
% Function to add input constraint to standard problem
%
% Input constraint:
% For sgn =  1 :
%    v < |vmax|
%
% For sgn = -1 :
%    -|vmax| < v
%
% For sgn =  0 :
%    -|vmax| < v < |vmax|
%
%
% DEFAULT VALUES
%      vmax = 1
%      sgn  = 0
%
% For vmax=0 no input constraint is added
%
if nargin<2.5
  vmax=1;
end;
if vmax==0
  return;
end;
vmax=abs(vmax);
if nargin<3.5
  sgn=0;
end;
 
[tA,tB,tC,tD]=ssdata(sys2); 
 
na =dim2(1); 
nb1=dim2(2); 
nb2=dim2(3); 
nb3=dim2(4); 
nc1=dim2(5); 
nc2=dim2(6); 
nc3=dim2(7); 
nc4=dim2(8); 
 
tC13    = tC(1            :nc1+nc2+nc3    ,             :               ); 
tC4     = tC(1+nc1+nc2+nc3:nc1+nc2+nc3+nc4,             :               ); 
tD16    = tD(1            :nc1+nc2+nc3    ,             :               ); 
tD79    = tD(1+nc1+nc2+nc3:nc1+nc2+nc3+nc4,             :               ); 

vmaxi=pinv(diag(vmax));
 
if sgn>-0.1
    tC4     = [tC4  ; zeros(nb3,na)         ];
    tD79    = [tD79 ; zeros(nb3,nb1+nb2) eye(nb3)*vmaxi ];
    dim2(8) = dim2(8)+nb3;
end;
if sgn<0.1
    tC4     = [tC4  ; zeros(nb3,na)         ];
    tD79    = [tD79 ; zeros(nb3,nb1+nb2) -eye(nb3)*vmaxi ];
    dim2(8) = dim2(8)+nb3;
end;
sys2    = ss(tA,tB,[tC13; tC4],[tD16 ; tD79],1);
 
