function[sys2,dim2] = add_y(sys2,dim2,ymax,sgn);
%
% [sysp,dimp] = add_y(sysp,dimp,ymax);
% [sysp,dimp] = add_y(sysp,dimp,ymax,sgn);
% [sys,dim] = add_y(sys,dim,ymax);
% [sys,dim] = add_y(sys,dim,ymax,sgn);
%
% Function to add output constraint to standard problem
%
% For sgn =  1 :
%    y < |ymax|
%
% For sgn = -1 :
%    -|ymax| < y
%
% For sgn =  0 :
%    -|ymax| < y < |ymax|
%
% DEFAULT VALUES
%      sgn = 0
%
% for ymax=0 no output constraint is added
%
if ymax==0
  return;
end;
ymax=abs(ymax);

if nargin<3.5
  sgn=0;
end;
 
[A,tB,tC,tD]=ssdata(sys2);
 
na =dim2(1); 
nb1=dim2(2); 
nb2=dim2(3); 
nb3=dim2(4); 
nc1=dim2(5); 
nc2=dim2(6); 
nc3=dim2(7); 
nc4=dim2(8); 

tC1     = tC(1            :nc1            ,             :               );

tC13    = tC(1            :nc1+nc2+nc3    ,             :               ); 
tC4     = tC(1+nc1+nc2+nc3:nc1+nc2+nc3+nc4,             :               ); 
tD13    = tD(1            :nc1            ,             :               );
tD16    = tD(1            :nc1+nc2+nc3    ,             :               );
tD79    = tD(1+nc1+nc2+nc3:nc1+nc2+nc3+nc4,             :               ); 
 
ymaxi=pinv(diag(ymax));

if sgn>-0.1
 tC4     = [ tC4  ; ymaxi*tC1  ];
 tD79    = [ tD79 ; ymaxi*tD13 ];
 dim2(8) = dim2(8)+nc1;
end;
if sgn<0.1
 tC4     = [ tC4  ; -ymaxi*tC1  ];
 tD79    = [ tD79 ; -ymaxi*tD13 ];
 dim2(8) = dim2(8)+nc1;
end;

sys2    = ss(A,tB,[tC13; tC4],[tD16 ; tD79],1);
 
