%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% gpc problem with personal settings
%
% File: demogpc0.m 
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 

clf;
clc;
randn('state',0);

if exist('emag')==0
   varemag= 0*1e-2 ;
else
   varemag=emag
end;

if exist('lensim')==0
  varlensim=61;
else
  varlensim=lensim;
end;
t=0:varlensim-1;

if exist('r')==0
  varr  = [zeros(1,10) ones(1,100) zeros(1,100)];
else
  varr=r;
end;

if exist('di')==0
  vardi = 0*[zeros(1,25) 0.5 zeros(1,184)];
else
  vardi =di;
end;
if exist('ei')==0
  varei = varemag*randn(1,varlensim);
else
  varei = ei;
end;
if exist('dumax')==0
  vardumax = 0; % 0.10001 ;
else
  vardumax = dumax;
end;

if exist('apr')==0
  varapr = [0 0];
else
  varapr=apr;
end;


%%%  G(q)       %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 
if exist('a')==0
  ao = conv([1 -0.882],[1 -0.905]);
  vara = conv(ao,[1 -1]);
  varb = 0.029*[0 1 0.928];
  varc = [ao 0];
  varf = [0 ao];
else
  vara = a;
  varb = b;
  varc = c;
  varf = f;
end;

%%%  P(q)       %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if exist('P')==0
  varP = 1;
else
  varP = P;
end;
if exist('lambda')==0
  varlambda=0   ;
else
  varlambda=lambda;
end;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if exist('Nm')==0
 varNm = 1;
else
 varNm = Nm;
end;
if exist('Nc')==0
 varNc = 2;
else
 varNc = Nc;
end;
if exist('N')==0
 varN = 25;
else
 varN = N;
end;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[y,du]=gpc(vara,varb,varc,varf,varP,varlambda,varNm,varN,varNc,varlensim,varr,vardi,varei,vardumax,varapr);
u  = cumsum(du);
do = cumsum(vardi(1:varlensim));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

rr = varr(:,1:varlensim);

subplot(211);
stairs(t,[y' rr' do']);
title(['Nm=',int2str(varNm),'   N=',int2str(varN)]);
grid; 
subplot(212);
stairs(t,[u']);
title(['Nc=',int2str(varNc),'   lambda=',num2str(varlambda)]);
grid; 
disp('   ');

