%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% Special settings for GPC controllers
% 
% File: demogpc9.m 
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 

clear;
clf;

emag= 0*1e-2 ;

lensim=101;
t=0:lensim-1;
r  = [zeros(1,10) ones(1,300)];
di = emag*randn(1,lensim+300);
ei = emag*randn(1,lensim+300);
dumax = 0; % 0.10001 ;
dumin = 0; % -0.10001 ;

apr = [0 0];

%%%  G(q)       %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 
% a = conv([1 -0.882],[1 -0.905]);
ao = [1 -1.787 0.79821];
a = conv(ao,[1 -1]);
b = 0.029*[0 1 +0.928 0];
c = [ao 0];
f = [0 ao];

%%%  P(q)       %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

P = 1;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 

lambda=0 ;
Nm = 1;
Nc = 1;
N  = 1;

disp('   ');
disp('Minimum variance control for a minimum phase process');
t0=clock;
[y1,du1]=gpc(a,b,c,f,P,lambda,Nm,N,Nc,lensim,r,di,ei,dumax,apr);
time1=etime(clock,t0);
u1 = cumsum(du1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[tt,rr] = stairs(t,r(:,1:lensim));
[tt,u1] = stairs(t,u1);

subplot(221);
crit1=(y1-r(:,1:lensim))*(y1-r(:,1:lensim))'+lambda^2*du1*du1';
%figure(1);
plot(tt,rr','--c',t,y1','b');
title(['Nm=',int2str(Nm),'   N=',int2str(N),'   Nc=',int2str(Nc),'  lam=',num2str(lambda)]);
ylabel('y')
xlabel('minimum variance control')
grid; 
%figure(2);
subplot(222);
plot(tt,u1','b');
title(['crit=',num2str(crit1),'   comp.time=',num2str(time1)]);
ylabel('u')
xlabel('minimum variance control')
grid;
disp('   ');

pause;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%  G(q)       %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% a = conv([1 -0.882],[1 -0.905]);
ao = [1 -1.787 0.79821];
a = conv(ao,[1 -1]);
b = 0.029*[0 1 +1.228 0];
c = [ao 0];
f = [0 ao];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

lambda=0;
Nm = 1;
Nc = 1;
N = 1 ;

t0=clock;
disp('   ');
disp('Minimum variance control for a non-minimum phase process');
[y2,du2]=gpc(a,b,c,f,P,lambda,Nm,N,Nc,lensim,r,di,ei,dumax,apr);
time2=etime(clock,t0);
u2 = cumsum(du2);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[tt,rr] = stairs(t,r(:,1:lensim));
[tt,u2] = stairs(t,u2);

subplot(223);
crit2=(y2-r(:,1:lensim))*(y2-r(:,1:lensim))'+lambda^2*du2*du2';
plot(tt,rr','--c',t,y2','b');
title(['Nm=',int2str(Nm),'   N=',int2str(N),'   Nc=',int2str(Nc),'  lam=',num2str(lambda)]);
ylabel('y')
xlabel('minimum variance control')
grid; 
%figure(4);
subplot(224);
plot(tt,u2','b');
title(['crit=',num2str(crit2),'   comp.time=',num2str(time2)]);
ylabel('u')
xlabel('minimum variance control')
grid;
disp('   ');
 

pause;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

lambda=0.01;
Nm = 1;
Nc = 1;
N = 1 ;

t0=clock;
disp('   ');
disp('Generalized minimum variance control for a non-minimum phase process');
[y2,du2]=gpc(a,b,c,f,P,lambda,Nm,N,Nc,lensim,r,di,ei,dumax,apr);
time2=etime(clock,t0);
u2 = cumsum(du2);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[tt,rr] = stairs(t,r(:,1:lensim));
[tt,u2] = stairs(t,u2);

crit2=(y2-r(:,1:lensim))*(y2-r(:,1:lensim))'+lambda^2*du2*du2';

subplot(223);
plot(tt,rr','--c',t,y2','b');
title(['Nm=',int2str(Nm),'   N=',int2str(N),'   Nc=',int2str(Nc),'  lam=',num2str(lambda)]);
ylabel('y')
xlabel('generalized minimum variance control')
grid;
%figure(4);
subplot(224);
plot(tt,u2','b');
title(['crit=',num2str(crit2),'   comp.time=',num2str(time2)]);
ylabel('u')
xlabel('generalized minimum variance control')
grid; 
disp('   ');

pause;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

lambda=0;
Nm = 2;
Nc = 3;
N = 4 ;

t0=clock;
disp('   ');
disp('Dead-beat control');
[y2,du2]=gpc(a,b,c,f,P,lambda,Nm,N,Nc,lensim,r,di,ei,dumax,apr);
time2=etime(clock,t0);
u2 = cumsum(du2);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


[tt,rr] = stairs(t,r(:,1:lensim));
[tt,u2] = stairs(t,u2);

crit2=(y2-r(:,1:lensim))*(y2-r(:,1:lensim))'+lambda^2*du2*du2';

subplot(221);
plot(tt,rr','--c',t,y2','b');
title(['Nm=',int2str(Nm),'   N=',int2str(N),'   Nc=',int2str(Nc),'  lam=',num2str(lambda)]);
ylabel('y')
xlabel('dead beat control')
grid; 
%figure(4);
subplot(222);
plot(tt,u2','b');
title(['crit=',num2str(crit2),'   comp.time=',num2str(time2)]);
ylabel('u')
xlabel('dead beat control')
grid; 
disp('   ');
 

pause;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

lambda=0;
Nm = 1;
Nc = 1;
N = Inf ;

t0=clock;
disp('   ');
disp('Mean level control');
[y2,du2]=gpc(a,b,c,f,P,lambda,Nm,N,Nc,lensim,r,di,ei,dumax,apr);
time2=etime(clock,t0);
u2 = cumsum(du2);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


[tt,rr] = stairs(t,r(:,1:lensim));
[tt,u2] = stairs(t,u2);

crit2=(y2-r(:,1:lensim))*(y2-r(:,1:lensim))'+lambda^2*du2*du2';

subplot(223);
plot(tt,rr','--c',t,y2','b');
title(['Nm=',int2str(Nm),'   N=',int2str(N),'   Nc=',int2str(Nc),'  lam=',num2str(lambda)]);
ylabel('y')
xlabel('mean level control')
grid; 
%figure(4);
subplot(224);
plot(tt,u2','b');
title(['crit=',num2str(crit2),'   comp.time=',num2str(time2)]);
ylabel('u')
xlabel('mean level control')
grid; 
disp('   ');
 
pause;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%  P(q)       %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

P = [1 -1.4 0.98];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

lambda=0;
Nm = 2;
Nc = 3;
N = 4 ;

t0=clock;
disp('   ');
disp('Pole placement control');
[y2,du2]=gpc(a,b,c,f,P,lambda,Nm,N,Nc,lensim,r,di,ei,dumax,apr);
time2=etime(clock,t0);
u2 = cumsum(du2);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


[tt,rr] = stairs(t,r(:,1:lensim));
[tt,u2] = stairs(t,u2);

crit2=(y2-r(:,1:lensim))*(y2-r(:,1:lensim))'+lambda^2*du2*du2';

subplot(221);
plot(tt,rr','--c',t,y2','b');
title(['Nm=',int2str(Nm),'   N=',int2str(N),'   Nc=',int2str(Nc),'  lam=',num2str(lambda)]);
ylabel('y')
xlabel('pole placement control')
grid; 
%figure(4);
subplot(222);
plot(tt,u2','b');
title(['crit=',num2str(crit2),'   comp.time=',num2str(time2)]);
ylabel('u')
xlabel('pole placement control')
grid; 
disp('   ');
 
