function [dGamma,Gammass] = dgamma(Nm,N,dim);
%
% [dGamma]            = dgamma(Nm,N,dim);
% [dGamma,Gammass]    = dgamma(Nm,N,dim);
%
% Creates matrix dGamma from Nm and N with dimensions of dim
% For the infinite horizon case the funtion also creates the steady state matrix Gammass
%
%   Nm  = minimum cost horizon
%   N   = prediction horizon
%   dim = [na nb1 nb2 nb3 nc1 nc2 nc3 nc4]
%

nu  = dim(4);
nz  = dim(6);
nz1 = nz-nu ;

%coefu = ceil((1:nu*Nc)/nu)*nz1+(1:nu*Nc);
coefu = ceil((1:nu*N)/nu)*nz1+(1:nu*N);
coefz = floor((nz1*(Nm-1):nz1*N-1)/nz1)*nu+(nz1*(Nm-1)+1:nz1*N);

dGamma = zeros(N*nz,1);
dGamma(coefu)=1;
dGamma(coefz)=1;

if nargout==2
  Gammass=[ones(nz1,1);zeros(nu,1)];
end;
