%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Example for gpc

ai = conv([1 -1.787 0.798],[1 -1]);              % polynomial ai(q)
bi = 0.029*[0 1 0.928 0];                        % polynomial bi(q)
ci = [1 -1.787 0.798 0];                         % polynomial ci(q)
fi = [0  1 -1.787 0.798];                        % polynomial fi(q)

P = 1;              % No pole-placement
lambda=0;           % increment input is not weighted
Nm = 8;             % Mimimum cost horizon
Nc = 2;             % Control horizon
N  = 25;            % Prediction horizon
lensim = 61;        % length simulation interval
r  = [zeros(1,10) ones(1,100)];      % step on k=11
di = [zeros(1,20) 0.5 zeros(1,89)];  % step on k=21
ei = [zeros(1,30) -0.1*randn(1,31)]; % noise starting from k=31
dumax = 0;          % dumax=0 means that no constraint is added !!
apr = [0 0];        % no apriori knowledge about w(k)

[y,du] = gpc(ai,bi,ci,fi,P,lambda,Nm,N,Nc,lensim,r,di,ei,dumax,apr);

u  = cumsum(du);       % compute   u(k)   from    du(k)
do = cumsum(di(1:61)); % compute   do(k)   from   di(k)
eo = cumsum(ei(1:61)); % compute   eo(k)   from   ei(k)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

t=0:60;
subplot(211);
stairs(t,[y' r(:,1:61)' do' eo']);
title('green: r , blue: y , red: do , cyan: eo');
grid;
subplot(212);
stairs(t,[du' u']);
title('blue: du , green: u');
grid;
disp('   ');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
