function[sys,dim]=gpc2spc(Gi,dimi,P,Wu,Wy);
%
% [sys,dim]=gpc2spc(Gi,dim,P,lambda);
% [sys,dim]=gpc2spc(Gi,dim,P,Wu,Wy);
%
% Transforms GPC problem into a standard predictive control problem
%
% System Gi is an IIO model:
%
%  xi(k+1) = Ai xi(k) + Ki ei(k) + Li di(k) + B du(k)
%  y(k)    = Ci xi(k) + DH ei(k) 
%
% system P(q) is given by;
%  xp(k+1) = Ap xp(k) + Bp y(k)
%  phi(k)  = Cp xp(k) = Dp y(k)
%
% System sys:
%
%   x(k+1) = A  x(k)  + B1  e(k)  + B2  w(k)  + B3  v(k)
%   y(k)   = C1 x(k)  + D11 e(k)  + D12 w(k)
%   z(k)   = C2 x(k)  + D21 e(k)  + D22 w(k)  + D23 v(k)
%
% If only lambda is given:
%
%   z(k) = [ phi(k+1)-r(k+1) ]
%          [ lambda du(k)    ]
%
% If Wu and Wy are given:
%
%   z(k) = [ Wy (phi(k+1)-r(k+1)) ]
%          [ Wu du(k)             ]
%
%
%

[Ai,KLBi,Ci,DHDF]= ssdata(Gi);
na =dimi(1);
nb1=dimi(2);
nb2=dimi(3);
nb3=dimi(4);
nc1=dimi(5);

Ki = KLBi(:,        1:nb1        );
Li = KLBi(:,    nb1+1:nb1+nb2    );
Bi = KLBi(:,nb1+nb2+1:nb1+nb2+nb3);

DH = DHDF(:,        1:nb1        );
DF = DHDF(:,    nb1+1:nb1+nb2    );

if max(max(abs(DF)))>1e-9
    disp('Only D_F=0 has been implemented')
    return;
end;

[Ap,Bp,Cp,Dp]= ssdata(P);


if nargin==4
  Wy=eye(nc1);
end;

if size(Ap,1)>0
 [nac,nap]=size(Cp);
 A  = [Ap Bp*Ci ; zeros(na,nap) Ai ];
 B1 = [Bp*DH;Ki];
 B2 = [zeros(nap,nb2+nc1);Li zeros(na,nc1)];
 B3 = [zeros(nap,nb3);Bi];
 C1 = [zeros(nac,nap) Ci ];
 Cf = [ Cp Dp*Ci];
 C2 = [ Wy*Cf*A  ; zeros(nb1,nap+na) ];
 D21 = [ Wy*Cf*B1 ; zeros(nb3,nb3)];
 D22 = [ Wy*Cf*[zeros(nap,nb2);Li]  -Wy; zeros(nb3,nb2+nc1)];
 D23 = [ Wy*Cf*B3 ; Wu*eye(nb3)];
else
 A  = Ai;
 B1 = Ki;
 B2 = [Li zeros(na,nc1)];
 B3 = Bi;
 C1 = Ci;
 C2 = [Wy*Ci*A  ; zeros(nb1,na) ];
 D21 = [Wy*Ci*B1 ; zeros(nb3,nb3)];
 D22 = [Wy*Ci*Li  -Wy; zeros(nb3,nb2+nc1)];
 D23 = [Wy*Ci*B3 ; Wu*eye(nb3)];
end;
D11=DH;
D12=zeros(nc1,nb2+nc1);
D13=zeros(nc1,nb3);

na=size(A,1);

Asys = A;
Bsys = [B1 B2 B3];
Csys = [C1;C2];
Dsys = [D11 D12 D13; D21 D22 D23];

sys = ss(Asys,Bsys,Csys,Dsys,1);
dim = [na nb1 nb2+nc1 nb3 nc1 nc1+nb3 0 0];

