function[y,du,sys,dim,vv]=gpc_ss(Ai,Ki,Li,Bi,Ci,DH,DF,Ap,Bp,Cp,Dp,Wy,Wu,Nm,N,Nc,lensim,r,di,ei,dumax,apr,rhc);
%
% [y,du]=gpc_ss(Ai,Ki,Li,Bi,Ci,DH,DF,Ap,Bp,Cp,Dp,Wy,Wu,Nm,N,Nc,lensim,r,di,ei,dumax,apr,rhc);
% [y,du,sys,dim,vv]=gpc_ss(Ai,Ki,Li,Bi,Ci,DH,DF,Ap,Bp,Cp,Dp,Wy,Wu,Nm,N,Nc,lensim,r,di,ei,dumax,apr,rhc);
%
% Solves the generalized predictive control problem
%
%   x(k+1)  = Ai x(k) + Ki ei(k) + Li di(k) + Bi du(k)
%   y(k)    = Ci x(k) + DH ei(k) + DF di(k)
%
%   xp(k+1) = Ap xp(k) + Bp y(k)
%   phi(k)  = Cp xp(k) + Dp y(k)
%
%   min sum |Wy*(phi(k)-r(k))|^2 + |Wu*du|^2
%
%   subject to  |du(k)| < dumax
%
%   Nm = minimum cost horizon
%   N  = prediction horizon
%   Nc = control horizon
%   lensim = length simulation interval
%
%   apr = [apr(1) apr(2)]; 
%   apr(1)=1 : reference signal d(k+j) is a priori known for j>0
%   apr(1)=0 : reference signal d(k+j) is not a priori known for j>0
%   apr(2)=1 : reference signal r(k+j) is a priori known for j>0
%   apr(2)=0 : reference signal r(k+j) is not a priori known for j>0
%
%   rhc=0 : the simulation is done in simulation mode
%   rhc=1 : the simulation is done in a receding horizon mode
%           (for receding horizon mode: Press ENTER button each time-step)
%
%   The output variables sys, dim and vv can be used as input variables for the functions
%   lticll and lticon

if nargin<20.5
  rhc=0;
  if nargin<19.5
    apr=1;
    if nargin<18.5
      dumax=0;
    end
  end;
end;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%     Check sizes
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

ndum=zeros(5,1);
[nA1,nA2]=size(Ai);
[nB1,nB2]=size(Bi);
[nC1,nC2]=size(Ci);
[nK1,nK2]=size(Ki);
[nL1,nL2]=size(Li);
[nPa,nPa]=size(Ap);
[nPb,nPc]=size(Dp);
[nDH1,nDH2]=size(DH);
[nDF1,nDF2]=size(DF);

if nA1~=nA2
 disp('matrix A must be square');
 return;
end;
if nB1~=nA1
 disp('matrix Ai and Bi must have same number of rows');
 return;
end;
if nC2~=nA1
 disp('matrix Ai and Ci must have same number of columns');
 return;
end;
if nK1~=nA1
 disp('matrix Ai and Ki must have same number of rows');
 return;
end;
if nK2~=nC1
 disp('# rows of matrix Ci must equal to # columns of matrix Ki');
 return;
end;
if nDH1~=nC1
 disp('# rows of matrix DH must equal to # rows of matrix Ci');
 return;
end;
if nDF1~=nC1
 disp('# rows of matrix DF must equal to # rows of matrix Ci');
 return;
end;
if nDH1~=nDH2
 disp('matrix DH must be square');
 return;
end;
if nDF2~=nL2
 disp('# columns of matrix DF must equal to # columns of matrix Li');
 return;
end;

if nL1~=nA1
 disp('matrix A and Li must have same number of rows');
 return;
end;
if nPb~=nPc
 disp('system P should be a square');
 return;
end;
if nPb~=nPc
 disp('system P should be a square');
 return;
end;
if nPb~=nc2
 disp('system P should be compatible with y');
 return;
end;

if Nm>N
 disp('minumum cost horizon Nm must be smaller or equal to N');
 return;
end;

if Nc>N
 disp('minumum cost horizon Nc must be smaller or equal to N');
 return;
end;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% N=N;

sysP = ss(Ap,Bp,Cp,Dp,1);

na = na1+nPa;

du = zeros(1,lensim);
y  = zeros(1,lensim); 
x  = zeros(na,lensim+1);
xc = zeros(na,lensim+1);
 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

disp('  '); 
disp(' ss2syst  <<');     [Gi,dimi]   = ss2syst(Ai,Ki,Li,Bi,Ci,DH,DF,0);
disp(' gpc2spc  <<');     [sys,dim]   = gpc2spc(Gi,dimi,sysP,Wu,Wy);
disp(' external <<');     tw          = external(apr,lensim,N,di,r(2:end));
disp(' dgamma   <<');     [dGam]      = dgamma(Nm,N,dim);
disp(' pred     <<');     [sysp,dimp] = pred(sys,dim,N);
if Nc<N;
  disp(' add_Nc   <<');   [sysp,dimp] = add_nc(sysp,dimp,dimi,Nc);
end;
disp(' add_du   <<');     [sysp,dimp] = add_du(sysp,dimp,dumax,0);
if rhc==1
  disp(' rhc      <<');   [x,xc,y,du] = rhc(sys,sys,sysp,dim,dimp,dGam,N,x,xc,y,du,tw,ei,1,lensim);
else
  disp(' contr    <<');   [vv,HH,ff,AA,bb] = contr(sysp,dimp,dim,dGam);
  disp(' simul    <<');   [x,xc,y,du] = simul(sys,sys,dim,N,x,xc,y,du,tw,ei,1,lensim,vv,HH,ff,AA,bb);
end;
