function[G,dim]=imp2syst(h,f,nimp);
%
% [G,dim]=imp2syst(h,f,nimp);
%
% Function transforms an impulse response model into a state space IO-model
% in the SYSTEM format ( only for SISO systems !!! )
%
% Input system:
%
%    y(k) = sum h(i) u(k-i) + sum f(i) d(k-i) + e(k)
%
%    h = [ h(0) h(1) .... h(nh) ]
%    f = [ f(0) f(1) .... f(nf) ]
%
%    where  h(0)=0  and  f(0)=0
%
%    nimp  is the length of the impulse response in the final model
%    If nimp is not given, nimp = max(nh,nf)
%
% Output system:
%
%    G   = [ A  B1 B2 B3 ]
%          [ C1 I  0  0  ]
%
%    dim = [ nA nB1 nB2 nB3 nC1 0 0 0 ] = [na 1 1 1 1 0 0 0];
%
%
nh = length(h)-1;
nf = length(f)-1;
if nargin==2
    nimp=max(nh,nf);
end;

n=nimp+1;
h = [0; h(2:min(n,nh));zeros(n-nh,1)];
f = [0; f(2:min(n,nf));zeros(n-nf,1)];

A = eye(n);
A = A(2:n,1:n-1);
B = [h(2:n)];
L = [f(2:n)];
C = [1 zeros(1,n-2)];
K = zeros(n-1,1);

G   = ss(A,[K L B],C,[1 0 0],1);
dim = [n-1 1 1 1 1 0 0 0];

