function [Acl,B1cl,B2cl,Ccl,D1cl,D2cl]=lticll(sys,dim,vv,N);
% [Acl,B1cl,B2cl,Ccl,D1cl,D2cl]=lticll(sys,dim,vv,N);
%
% Function computes the state space matrices of the
% LTI closed loop
%
% sys  = model
% dim  = dimensions sys
% vv   = LTI controller parameters (see function contr.m)
% N    = prediction horizon
%

[A,B1,B2,B3,C1,D11,D12,D13]=syst2ss(sys,dim);

na  = dim(1);
nb1 = dim(2);
nb2 = dim(3);
nb3 = dim(4);
nc1 = dim(5);

D11i=inv(D11);

Ew = [eye(nb2)  zeros(nb2,(N-1)*nb2)];
%Ew  = [ones(1,nb2) zeros(1,(N-1)*nb2)];
F   = -vv(1:nb3,1   :na            );
De  = vv(1:nb3,na+1:na+nb1        );
Dw  = vv(1:nb3,na+nb1+1:na+nb1+N*nb2);

Acl  = [ A-B3*F          -B3*F-B3*De*D11i*C1 ; zeros(na,na)  A-B1*D11i*C1 ];
B1cl = [ B1+B3*De      ; zeros(na,nb1)  ];
B2cl = [ B3*Dw+B2*Ew   ; zeros(na,N*nb2)  ];
Ccl  = [ -F   -F-De*D11i*C1       ; C1   zeros(nb1,na)];
D1cl = [ De ; D11 ];
D2cl = [ Dw ; D12*Ew ];
