function [Ac,B1c,B2c,Cc,D1c,D2c]=lticon(sys,dim,vv,N);
% [Ac,B1c,B2c,Cc,D1c,D2c]=lticon(sys,dim,vv,N);
%
% Function computes the state space matrices of
% the LTI optimal predictive controller
%
% sys  = model
% dim  = dimensions sys
% vv   = LTI controller parameters (see function contr.m)
% N    = prediction horizon
%

[A,B1,B2,B3,C1,D11,D12,D13]=syst2ss(sys,dim);

na  = dim(1);
nb1 = dim(2);
nb2 = dim(3);
nb3 = dim(4);
nc1 = dim(5);

D11i=inv(D11);

Ew = [eye(nb2)  zeros(nb2,(N-1)*nb2)];
%Ew  = [ones(1,nb2) zeros(1,(N-1)*nb2)];
F   = -vv(1:nb3,1   :na            );
De  = vv(1:nb3,na+1:na+nb1        );
Dw  = vv(1:nb3,na+nb1+1:na+nb1+N*nb2);

Ac   = A-B3*F-B1*D11i*C1-B3*De*D11i*C1;
B1c  = B1*D11i+B3*De*D11i;
B2c  = B3*Dw-B3*De*D11i*D12*Ew+B2*Ew-B1*D11i*D12*Ew;
Cc   = -F-De*D11i*C1;
D1c  = De*D11i;
D2c  = Dw-De*D11i*D12*Ew;
