function[sys2,dim2]=pred(sys,dim,N);
%
% [sys2,dim2]=pred(sys,dim,N);
%
% Functions makes a prediction model
%
% System sys:
%   x(k+1) = A  x(k) + B1  e(k) + B2  w(k) + B3  v(k)
%   y(k)   = C1 x(k) + D11 e(k) + D12 w(k) 
%   z(k)   = C2 x(k) + D21 e(k) + D22 w(k) + D23 v(k)
%   phi(k) = C3 x(k) + D31 e(k) + D32 w(k) + D33 v(k)
%   psi(k) = C4 x(k) + D41 e(k) + D42 w(k) + D43 v(k)
%
% System sys2:
%   x(k+1)  = Ap  x(k) + B1p  e(k) + B2p  tw(k) + B3p  tv(k)
%   ty(k)   = C1p x(k) + D11p e(k) + D12p tw(k) + D13p tv(k)
%   tz(k)   = C2p x(k) + D21p e(k) + D22p tw(k) + D23p tv(k)
%   tphi(k) = C3p x(k) + D31p e(k) + D32p tw(k) + D33p tv(k)
%   tpsi(k) = C4p x(k) + D41p e(k) + D42p tw(k) + D43p tv(k)
%
% where
%            | y(k)     |                | z(k)     |               | w(k)     |                | v(k)     |
%   ty(k)  = | y(k+1)   |       tz(k)  = | z(k+1)   |      tw(k)  = | w(k+1)   |       tv(k)  = | v(k+1)   |
%            |  :       |                |  :       |               |  :       |                |  :       |
%            | y(k+N-1) |                | z(k+N-1) |               | w(k+N-1) |                | v(k+N-1) |
%
%             | phi(k)     |                 | psi(k)     |     
%   tphi(k) = | phi(k+1)   |       tpsi(k) = | psi(k+1)   |    
%             |  :         |                 |  :         |     
%             | phi(k+N-1) |                 | psi(k+N-1) |     
%
% N = prediction horizon  
%

na =dim(1);
nb1=dim(2);
nb2=dim(3);
nb3=dim(4);
nc1=dim(5);
nc2=dim(6);
nc3=dim(7);
nc4=dim(8);

[A,B1,B2,B3,C1,D11,D12,D13,C2,D21,D22,D23,C3,D31,D32,D33,C4,D41,D42,D43]=syst2ss(sys,dim);
%pause
                                                                    
[tC1,tD11,tD12,tD13]=blockmat(A,B1,B2,B3,C1,D11,D12,D13,N);

[tC2,tD21,tD22,tD23]=blockmat(A,B1,B2,B3,C2,D21,D22,D23,N);

tC3 = [];
tD31 = [];
tD32= [];
tD33= [];

if nc3>0.1
  [tC3,tD31,tD32,tD33]=blockmat(A,B1,B2,B3,C3,D31,D32,D33,N);
end;

tC4  = [];
tD41  = [];
tD42 = [];
tD43 = [];

if nc4>0.1
  [tC4,tD41,tD42,tD43]=blockmat(A,B1,B2,B3,C4,D41,D42,D43,N);
end;

tB = [ B1 B2 zeros(na,(N-1)*nb2) B3 zeros(na,(N-1)*nb3)];
tC = [ tC1 ; tC2 ; tC3 ; tC4 ];
%size(tD11)
%size(tD12)
%size(tD13) 
%size([tD21 tD22 tD23; tD31 tD32 tD33 ; tD41 tD42 tD43])

tD = [ tD11 tD12 tD13 ; tD21 tD22 tD23 ; tD31 tD32 tD33 ; tD41 tD42 tD43 ];

sys2 = ss(A,tB,tC,tD,1);
dim2 = dim.*[1 1 N N N N N N];
