function[x,xc,y,v]=rhc(syst,sys,sysp,dim,dimp,dGam,N,x,xc,y,v,tw,e,k1,k2,kk,pp);
%
% [x,xc,y,v]=rhc(syst,sys,sysp,dim,dimp,dGam,N,x,xc,y,v,tw,e,k1,k2);
%
% syst = true system
% sys  = model
% sysp = prediction model
% dim  = dimensions sys en syst
% dimp = dimensions sysp
% dGam = selection matrix
% N    = prediction horizon
% x    = state true system
% xc   = state model/controller
% y    = true system output
% v    = true system input
% tw   = known external signals
% e    = noise signal
% k1   = begin simulation interval
% k2   = end simulation interval
%

if nargin<15.5
  kk=k1:k2;
  pp=1;
end;

%[vv,HH,ff,AA,bb]= contr(sysp,dimp,dim,dGam,1);
[vv,HH,AA,bb] = contr(sysp,dimp,dim,dGam,1);

na  = dim(1);
nb1 = dim(2);
nb2 = dim(3);
nb3 = dim(4);
nc1 = dim(5);

tna  = dimp(1);
tnb1 = dimp(2);
tnb2 = dimp(3);
tnb3 = dimp(4);
tnc1 = dimp(5);

[A,B1,B2,B3,C1,D11,D12,D13]=syst2ss(sys,dim);
[At,Bt1,Bt2,Bt3,Ct,Dt11,Dt12,Dt13]=syst2ss(syst,dim);
%[Asys,Bsys,Csys,Dsys]= ssdata(sys);
%[Asyst,Bsyst,Csyst,Dsyst]= ssdata(syst);

%[A,B1,B2,B3,C1]=syst2ss(sys,dim);
%[At,Bt1,Bt2,Bt3,Ct]=syst2ss(syst,dim);
[A,tB1,tB2,tB3,tC1,tD11,tD12,tD13]=syst2ss(sysp,dimp);
 
%[Asysp,Bsysp,Csysp,Dsysp]= ssdata(sysp);
%tA   =  Asysp;
%tB1  =  Bsysp( :    ,1          :tnb1          );
%tB2  =  Bsysp( :    ,1+tnb1     :tnb1+tnb2     );
%tB3  =  Bsysp( :    ,tnb1+tnb2+1:tnb1+tnb2+tnb3);
%tC1  =  Csysp(1:tnc1,           :              );
%tD1  =  Dsysp(1:tnc1,1          :tnb1          );
%tD2  =  Dsysp(1:tnc1,1+tnb1     :tnb1+tnb2     );
%tD3  =  Dsysp(1:tnc1,tnb1+tnb2+1:tnb1+tnb2+tnb3);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
tr = tw(nb2-nc1+1:nb2:tnb2,:);
d  = cumsum(tw(1:nb2:tnb2+nc1-nb2,:)')'
size(tr)
size(d)

if size(HH,1)>0
  f=zeros(nHH,1);
  for k=k1:k2-1

    y(:,k)    = Ct*x(:,k)+Dt11*e(:,k)+Dt12*tw(1:nb2,k);
    he        = inv(D11)*(y(:,k)-D12*tw(1:nb2,k)-C1*xc(:,k));
    signal    = [xc(:,k);he;tw(:,k)];
    b         = bb*[1;signal];
    nuk       = qp(HH,f,AA,b);
    tv        = vv*[signal;nuk];
    ty        = tC1*x(:,k)+tD11*he     + tD12*tw(:,k)  + tD13*tv;
    v(:,k)    = tv(1:nb3);
    xc(:,k+1) = A*xc(:,k) + B1*he      + B2*tw(1:nb2,k)  + B3*v(:,k);
    x(:,k+1)  = At*x(:,k) + Bt1*e(:,k) + Bt2*tw(1:nb2,k) + Bt3*v(:,k);
    k3 = min(k+N-1,k2);
    k4 = min(k+N-2,k2-1);

    if any(k==kk)
      size(ty)
      k3-k+1
      subplot(211)
      [t1,y1]=stairs((k1:k),y(:,k1:k));
      [t2,y2]=stairs((k:k3),ty(1:k3-k+1));
      [t2,r2]=stairs((k:k3),tr(1:k3-k+1,k));
      [t3,y3]=stairs((k3:k2),ty(N+1)*ones(1,k2-k3+1));
      [t4,d4]=stairs((1:k3),[d(1,1:k-1) d(1:k3-k+1,k)']);
      plot(t1-1,y1,'g',t2-1,y2,'r',t2-1,r2,'b',t3-1,y3,'c',t4-1,d4,':k');
      axiy=axis;
      hold on;
      plot([k-1,k-1],axiy(3:4),':m');
      plot([k4,k4],axiy(3:4),':m');
      hold off;
      title('Red: Predicted output, Blue: reference, Green: past output');
      subplot(212)
      [t1,u1]=stairs((k1:k),v(:,k1:k));
      [t2,u2]=stairs((k:k3),tv(1:k3-k+1));
      [t3,u3]=stairs((k3:k2),zeros(1,k2-k3+1));
      plot(t1-1,u1,'g',t2-1,u2,'r',t3-1,u3,'c');
      axiu=axis;
      hold on;
      plot([k-1,k-1],axiu(3:4),':m');
      plot([k4,k4],axiu(3:4),':m');
      hold off;
      title('Red: Optimal future input sequence, Green: past input');
      if pp==1
        pause;
      end;
    end;
  end;
else
  for k=k1:k2-1
    y(:,k)    = Ct*x(:,k)+Dt11*e(:,k)+Dt12*tw(1:nb2,k);
    he        = inv(D11)*(y(:,k)-D12*tw(1:nb2,k)-C1*xc(:,k));
    tv        = vv*[xc(:,k); he;tw(:,k)];
    ty        = tC1*x(:,k)+tD11*he     + tD12*tw(:,k)  + tD13*tv;
    v(:,k)    = tv(1:nb3);
    xc(:,k+1) = A*xc(:,k) + B1*he      + B2*tw(1:nb2,k)  + B3*v(:,k);
    x(:,k+1)  = At*x(:,k) + Bt1*e(:,k) + Bt2*tw(1:nb2,k) + Bt3*v(:,k);
    k3 = min(k+N-1,k2);
    k4 = min(k+N-2,k2-1);

    if any(k==kk)
      %[k k2 k3 k4]
      subplot(211)
      [t1,y1]=stairs((k1:k),y(:,k1:k));
      [t2,y2]=stairs((k:k3),ty(1:k3-k+1));
      [t2,r2]=stairs((k:k3),tr(1:k3-k+1,k));
      [t3,y3]=stairs((k3:k2),ty(N)*ones(1,k2-k3+1));
      [t4,d4]=stairs((1:k3),[d(1,1:k-1) d(1:k3-k+1,k)']);
      plot(t1-1,y1,'g',t2-1,y2,'r',t2-1,r2,'b',t3-1,y3,'c',t4-1,d4,':k');
      axiy=axis;
      hold on;
      plot([k-1,k-1],axiy(3:4),':m');
      plot([k4,k4],axiy(3:4),':m');
      hold off;
      title('Red: Predicted output, Blue: reference, Green: past output');
      subplot(212)
      [t1,u1]=stairs((k1:k),v(:,k1:k));
      [t2,u2]=stairs((k:k3),tv(1:k3-k+1));
      [t3,u3]=stairs((k3:k2),zeros(1,k2-k3+1));
      plot(t1-1,u1,'g',t2-1,u2,'r',t3-1,u3,'c');
      axiu=axis;
      hold on;
      plot([k-1,k-1],axiu(3:4),':m');
      plot([k4,k4],axiu(3:4),':m');
      hold off;
      title('Red: Optimal future input sequence, Green: past input');
      if pp==1
        pause;
      end;
    end;
  end;
end;



