function[x,xc,y,v,error]=simul(syst,sys,dim,Nc,x,xc,y,v,tw,e,k1,k2,vv,HH,AA,bb);
%
% Function makes a closed loop simulation with predictive controller
%
% syst = true system
% sys  = model
% dim  = dimensions sys en syst
% Nc   = control horizon
% x    = state true system
% xc   = state model/controller
% y    = true system output
% v    = true system input
% k1   = begin simulation interval
% k2   = end simulation interval
% vv,HH,ff,AA,bb = controller parameters
%
% For inequality constrained case:
%   [x,xc,y,v]=simul(syst,sys,dim,N,x,xc,y,v,tw,e,k1,k2,vv,HH,AA,bb);
%
% For equality constrained / unconstrained case:
%   [x,xc,y,v]=simul(syst,sys,dim,N,x,xc,y,v,tw,e,k1,k2,vv);
%
error=0;
numinput=(nargin-13)*(nargin-16);

if (nargin-13)*(nargin-16)~=0
  disp('wrong number of input variables');
  nargin
  error=1;
  return;
end;

if nargin==13
  HH=[]; AA=[]; bb=[];
end;

na  = dim(1);
nb1 = dim(2);
nb2 = dim(3);
nb3 = dim(4);
nc1 = dim(5);

[A,B1,B2,B3,C1,D11,D12,D13]=syst2ss(sys,dim);
[At,Bt1,Bt2,Bt3,Ct,Dt11,Dt12,Dt13]=syst2ss(syst,dim);

nHH=size(HH,1);
if nHH>0
  f=zeros(nHH,1);
  for k=k1:k2
    %size(Ct*x(:,k)), size(Dt11*e(:,k)), size(Dt12*tw(1:nb2,k))
    y(:,k)    = Ct*x(:,k)+Dt11*e(:,k)+Dt12*tw(1:nb2,k);
    he        = inv(D11)*(y(:,k)-D12*tw(1:nb2,k)-C1*xc(:,k));
    signal    = [xc(:,k);he;tw(:,k)];
    b         = bb*[1;signal];
    nuk       = qp(HH,f,AA,b);
    v(:,k)    = vv*[signal;nuk];
    xc(:,k+1) = A*xc(:,k) + B1*he      + B2*tw(1:nb2,k)  + B3*v(:,k);
    x(:,k+1)  = At*x(:,k) + Bt1*e(:,k) + Bt2*tw(1:nb2,k) + Bt3*v(:,k);
  end;
else
  for k=k1:k2
    y(:,k)    = Ct*x(:,k)+Dt11*e(:,k)+Dt12*tw(1:nb2,k);
    he        = inv(D11)*(y(:,k)-D12*tw(1:nb2,k)-C1*xc(:,k));
    %y(:,k)    = Ct*x(:,k)+e(:,k);
    %he        = y(:,k)-C1*xc(:,k);
    v(:,k)    = vv*[xc(:,k); he;tw(:,k)];
    xc(:,k+1) = A*xc(:,k) + B1*he      + B2*tw(1:nb2,k)  + B3*v(:,k);
    x(:,k+1)  = At*x(:,k) + Bt1*e(:,k) + Bt2*tw(1:nb2,k) + Bt3*v(:,k);
  end;
end;


