function[G,dim]=tf2syst(a,b,c,f);
%
% [G,dim]=tf2syst(a,b,c,f);
%
% Function transforms a polynomial model into a state space model in
% the SYSTEM format   ( only for SISO systems !!! )
%
% Input system:
%
%    a(q) y(k) = b(q) u(k) + c(q) e(k) + f(q) d(k)
%
% Output system:
%
%    G   = [ A  B1  B2  B3 ]
%          [ C1 D11 D12 0  ]
%
%    dim = [ nA nB1 nB2 nB3 nC1 0 0 0 ] = [na 1 1 1 1 0 0 0];
%
%

b = b/a(1);
c = c/c(1);
a = a/a(1);
f = f/a(1);

[At,Ct,Bt,Dt]    = tf2ss(b,a) ;
[AHt,CHt,Kt,DHt] = tf2ss(c,a) ;
[AFt,CFt,Lt,DFt]  = tf2ss(f,a) ;

G   = ss(At',[Kt' Lt' Bt'],Ct',[DHt' DFt' Dt'],1);
dim = [size(Kt') size(Lt,1) size(Bt,1) size(Ct,2) 0 0 0];

